/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.impl;

import de.intarsys.security.tl.ITrustedList;
import de.intarsys.security.tl.ITrustedListManager;
import de.intarsys.security.tl.TrustedListManager;
import de.intarsys.tools.streaming.StreamingTools;
import java.util.ArrayList;
import java.util.List;

public class TrustedListManagerTools {
    private static final String TSL_TYPE_EULISTOFTHELISTS = "http://uri.etsi.org/TrstSvc/TrustedList/TSLType/EUlistofthelists";
    private static final String EU = "EU";
    private static final List<String> EU_MEMBER_STATES = List.of("AT", "BE", "BG", "CY", "CZ", "DE", "DK", "EE", "EL", "ES", "FI", "FR", "HR", "HU", "IE", "IS", "IT", "LI", "LT", "LU", "LV", "MT", "NL", "NO", "PL", "PT", "RO", "SE", "SI", "SK");

    public static ITrustedList getEUListOfTheLists() {
        return TrustedListManagerTools.getEUListOfTheLists(TrustedListManager.get());
    }

    public static ITrustedList getEUListOfTheLists(ITrustedListManager trustedListManager) {
        return StreamingTools.asStream(trustedListManager.lookupTrustedLists()).filter(tl -> EU.equals(tl.getTerritory()) && TSL_TYPE_EULISTOFTHELISTS.equals(tl.getImpl().getSchemeInformation().getTSLType())).findAny().orElse(null);
    }

    public static List<String> getTerritories(ITrustedList trustedList) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(trustedList.getTerritory());
        if (TrustedListManagerTools.isEULinkedTrustedList(trustedList)) {
            result.add(EU);
        }
        return result;
    }

    public static boolean isEULinkedTrustedList(ITrustedList trustedList) {
        String territory = trustedList.getTerritory();
        return EU_MEMBER_STATES.contains(territory);
    }

    private TrustedListManagerTools() {
    }
}

