/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.impl;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.tl.ITrustedList;
import de.intarsys.security.tl.ITrustedListPointer;
import de.intarsys.security.tl.impl.ServiceDigitalIdentities;
import jakarta.xml.bind.JAXBElement;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import javax.xml.namespace.QName;
import org.etsi.uri._02231.v2.AdditionalInformationType;
import org.etsi.uri._02231.v2.AnyType;
import org.etsi.uri._02231.v2.DigitalIdentityListType;
import org.etsi.uri._02231.v2.DigitalIdentityType;
import org.etsi.uri._02231.v2.OtherTSLPointerType;
import org.w3c.dom.Element;

public class TrustedListPointer
implements ITrustedListPointer,
ICertificateProvider {
    private final OtherTSLPointerType impl;
    private final ITrustedList trustedList;
    private ServiceDigitalIdentities digitalIdentities;

    public TrustedListPointer(OtherTSLPointerType impl, ITrustedList trustedList) {
        this.impl = impl;
        this.trustedList = trustedList;
    }

    protected boolean accept(IX509CertificateFilter filter) {
        IX509CertificateSelector selector;
        return !(filter instanceof IX509CertificateSelector) || (selector = (IX509CertificateSelector)filter).hasPrivateKey() == null || selector.hasPrivateKey() != true;
    }

    public boolean containsCertificate(IX509Certificate certificate) {
        return this.getCertificates().contains(certificate);
    }

    protected List<AnyType> getAdditionalInformation() {
        AdditionalInformationType additionalInformation = this.getImpl().getAdditionalInformation();
        if (additionalInformation == null) {
            return Collections.emptyList();
        }
        return additionalInformation.getTextualInformationOrOtherInformation();
    }

    protected Object getAdditionalInformation(QName name) {
        for (AnyType object : this.getAdditionalInformation()) {
            for (Object element : object.getContent()) {
                Element domElement;
                QName elementQName;
                if (element instanceof JAXBElement) {
                    JAXBElement jaxbElement = (JAXBElement)element;
                    if (!name.equals(jaxbElement.getName())) continue;
                    return jaxbElement.getValue();
                }
                if (!(element instanceof Element) || !name.equals(elementQName = new QName((domElement = (Element)element).getNamespaceURI(), domElement.getLocalName()))) continue;
                return element;
            }
        }
        return null;
    }

    @Override
    public List<IX509PublicKeyCertificate> getCertificates() {
        return this.getDigitalIdentities().getCertificates();
    }

    protected ServiceDigitalIdentities getDigitalIdentities() {
        if (this.digitalIdentities == null) {
            ArrayList<DigitalIdentityType> all = new ArrayList<DigitalIdentityType>();
            List serviceDigitalIdentities = this.getImpl().getServiceDigitalIdentities().getServiceDigitalIdentity();
            for (DigitalIdentityListType digitalIdentityList : serviceDigitalIdentities) {
                all.addAll(digitalIdentityList.getDigitalId());
            }
            this.digitalIdentities = new ServiceDigitalIdentities(all, this);
        }
        return this.digitalIdentities;
    }

    public OtherTSLPointerType getImpl() {
        return this.impl;
    }

    @Override
    public String getLocation() {
        return this.getImpl().getTSLLocation();
    }

    @Override
    public String getMimeType() {
        Element element = (Element)this.getAdditionalInformation(new QName("http://uri.etsi.org/02231/v2/additionaltypes#", "MimeType"));
        if (element == null && (element = (Element)this.getAdditionalInformation(new QName("http://uri.etsi.org/01903/v1.3.2#", "MimeType"))) == null) {
            return null;
        }
        return element.getTextContent();
    }

    @Override
    public PublicKey getPublicKey() {
        return this.getDigitalIdentities().getPublicKey();
    }

    @Override
    public byte[] getSubjectKeyIdentifier() {
        return this.getDigitalIdentities().getSubjectKeyIdentifier();
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        return this.getDigitalIdentities().getSubjectX500Principal();
    }

    public ITrustedList getTrustedList() {
        return this.trustedList;
    }

    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        if (!this.accept(filter)) {
            return Collections.emptyIterator();
        }
        return this.getCertificates().stream().filter(filter).map(cert -> cert).iterator();
    }

    public String toString() {
        return "TrustedListPointer to " + this.getLocation() + " | type " + this.getMimeType();
    }
}

