/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.impl;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.certificate.provider.ICertificateProviderSupport;
import de.intarsys.security.tl.ITSPService;
import de.intarsys.security.tl.ITrustedList;
import de.intarsys.security.tl.ITrustedListPointer;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.collection.FilterIterator;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.jaxb.JAXBTools;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.etsi.uri._02231.v2.TrustStatusListType;

public class TrustedListTools {
    public static final String MIMETYPE_TLS_XML = "application/vnd.etsi.tsl+xml";
    public static final String MIMETYPE_APPLICATION_SHA2 = "application/sha2";

    public static List<ITrustedListPointer> getDerivedPointers(ITrustedList trustedList) {
        return ListTools.toList((Iterator)new FilterIterator<ITrustedListPointer>(trustedList.getTSLPointers().iterator()){

            protected boolean accept(ITrustedListPointer pointer) {
                String mimeType = pointer.getMimeType();
                return mimeType == null || TrustedListTools.MIMETYPE_TLS_XML.equals(mimeType);
            }
        });
    }

    public static String getLabel(ITrustedList trustedList) {
        StringBuilder name = new StringBuilder();
        String territory = trustedList.getTerritory();
        if (!StringTools.isEmpty((String)territory)) {
            name.append(territory).append(" / ");
        }
        name.append(trustedList.getOperatorName());
        return name.toString();
    }

    public static ITSPService getService(IX509Certificate certificate) {
        if (certificate instanceof ICertificateProviderSupport) {
            ICertificateProvider certificateProvider = certificate.getCertificateProvider();
            return (ITSPService)AdapterTools.getAdapter((Object)certificateProvider, ITSPService.class, null);
        }
        return null;
    }

    public static ITrustedListPointer getTSLPointer(IX509Certificate certificate) {
        if (certificate instanceof ICertificateProviderSupport) {
            ICertificateProvider certificateProvider = certificate.getCertificateProvider();
            return (ITrustedListPointer)AdapterTools.getAdapter((Object)certificateProvider, ITrustedListPointer.class, null);
        }
        return null;
    }

    public static TrustStatusListType parseTrustStatusList(ILocator locator) throws IOException {
        return (TrustStatusListType)JAXBTools.unmarshalElement((ILocator)locator, TrustStatusListType.class);
    }

    public static TrustStatusListType parseTrustStatusList(InputStream is) throws IOException {
        return (TrustStatusListType)JAXBTools.unmarshalElement((InputStream)is, TrustStatusListType.class);
    }

    private TrustedListTools() {
    }
}

