/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.manager;

import de.intarsys.security.tl.ITrustedList;
import de.intarsys.security.tl.impl.TrustedList;
import de.intarsys.security.tl.manager.CommonTrustedListManager;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.locator.FileLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class BasicTrustedListManager
extends CommonTrustedListManager
implements IElementConfigurable {
    private final List<ITrustedList> trustedLists = new ArrayList<ITrustedList>();
    private ILocator baseLocator;

    public BasicTrustedListManager() {
    }

    public BasicTrustedListManager(ILocator baseLocator) {
        this.baseLocator = baseLocator;
    }

    public void configure(IElement element) throws ConfigurationException {
        try {
            String baseDirPath = ElementTools.getString((IElement)element, (String)"basedir", (String)"tsl");
            ILocator locator = new FileLocatorFactory().createLocator(baseDirPath);
            this.setBaseLocator(locator);
        }
        catch (IOException e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    public ILocator getBaseLocator() {
        return this.baseLocator;
    }

    @PostConstruct
    public void load() throws IOException {
        this.loadDirectory(this.getBaseLocator());
    }

    protected void loadDirectory(ILocator directory) throws IOException {
        ILocator[] children;
        for (ILocator child : children = directory.listLocators(null)) {
            if (child.isDirectory()) {
                this.loadDirectory(child);
                continue;
            }
            this.loadFile(child);
        }
    }

    protected void loadFile(ILocator file) throws IOException {
        if (!LocatorTools.getExtension((ILocator)file).toLowerCase().equals("xml")) {
            return;
        }
        TrustedList trustedList = TrustedList.create(file);
        this.register(trustedList);
    }

    @Override
    public Iterator<ITrustedList> lookupTrustedLists() {
        return this.trustedLists.iterator();
    }

    public void register(ITrustedList trustedList) {
        this.trustedLists.add(trustedList);
    }

    public void setBaseLocator(ILocator baseLocator) {
        this.baseLocator = baseLocator;
    }
}

