/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.manager;

import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.tl.ITrustedList;
import de.intarsys.security.tl.ITrustedListPointer;
import de.intarsys.security.tl.impl.TrustedList;
import de.intarsys.security.tl.impl.TrustedListTools;
import de.intarsys.security.tl.manager.ITrustedListEntry;
import de.intarsys.security.tl.tools.TSLRemoteTarget;
import de.intarsys.security.tl.validation.IVSTrustedList;
import de.intarsys.security.tl.validation.TrustedListValidator;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public abstract class CommonTrustedListEntry
implements ITrustedListEntry {
    private static final Logger Log = LoggerFactory.getLogger(CommonTrustedListEntry.class);
    private ITrustedList trustedList;
    private IDigest contentDigest;
    private int validationState = -1;
    private TSLRemoteTarget tslTarget;

    protected CommonTrustedListEntry() {
    }

    protected void digestLocator() throws IOException {
        try (InputStream is = this.getLocator().getInputStream();){
            IDigester digester;
            try {
                digester = DigestTools.createDigester((String)"SHA-256");
            }
            catch (NoSuchAlgorithmException e) {
                throw new IOException("error digesting trusted list");
            }
            digester.digestUpdate(is);
            this.contentDigest = digester.digestFinal();
        }
    }

    protected IDigest getContentDigest() {
        if (this.contentDigest == null) {
            try {
                this.digestLocator();
            }
            catch (IOException e) {
                Log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return this.contentDigest;
    }

    @Override
    public List<ITrustedListPointer> getDerivedPointers() {
        return TrustedListTools.getDerivedPointers(this.getTrustedList());
    }

    protected abstract ILocator getLocator();

    @Override
    public ITrustedList getTrustedList() {
        return this.trustedList;
    }

    public TSLRemoteTarget getTSLTarget() {
        if (this.tslTarget == null) {
            this.tslTarget = new TSLRemoteTarget(this.getUrl());
        }
        return this.tslTarget;
    }

    public int getValidationState() {
        return this.validationState;
    }

    @Override
    public boolean isLoaded() {
        return this.trustedList != null;
    }

    @Override
    public boolean isUpdateAvailable() {
        if (!this.getLocator().exists()) {
            return true;
        }
        IDigest contentDigest = this.getContentDigest();
        if (contentDigest == null) {
            return true;
        }
        IDigest onlineDigest = this.getTSLTarget().getDigest();
        if (onlineDigest == null) {
            return true;
        }
        return !contentDigest.equals(onlineDigest);
    }

    @Override
    public boolean isValid() {
        return this.getValidationState() == 0;
    }

    @Override
    public void load() throws IOException {
        Log.trace("Loading trust list from " + this.getLocator().getPath());
        if (!this.getLocator().exists()) {
            Log.trace("Skipping, location does not exist.");
            return;
        }
        this.setTrustedList(TrustedList.create(this.getLocator()));
    }

    protected void reset() {
        this.trustedList = null;
        this.contentDigest = null;
        this.validationState = -1;
    }

    protected void setTrustedList(ITrustedList trustedList) {
        this.trustedList = trustedList;
    }

    public void setTSLTarget(TSLRemoteTarget tslTarget) {
        this.tslTarget = tslTarget;
    }

    @Override
    public IVSTrustedList validate() {
        if (Log.isEnabledForLevel(Level.DEBUG)) {
            Log.debug("Validating TSL file ", (Object)this.getLocator().getPath());
        }
        ValidationParameters parameters = new ValidationParameters();
        parameters.setTrustedCerts(this.getPointer().getCertificates());
        TrustedListValidator validator = new TrustedListValidator();
        IVSTrustedList validationState = validator.validate(this.getTrustedList(), (IValidationParameters)parameters);
        this.validationState = validationState.getState();
        if (validationState.isValid()) {
            if (Log.isEnabledForLevel(Level.DEBUG)) {
                Log.debug("TSL valid.");
            }
            if (!validationState.getValidityPeriodState().isValid()) {
                List messages = validationState.getValidityPeriodState().getMessages();
                for (IValidationMessage message : messages) {
                    if (message.getSeverity() >= 2) continue;
                    Log.warn(message.getText());
                }
            }
        } else {
            Log.warn("TSL not valid. Details:\n", (Object)validationState.toString());
        }
        return validationState;
    }
}

