/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.manager;

import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.tl.ITrustedList;
import de.intarsys.security.tl.ITrustedListManager;
import de.intarsys.tools.adapter.AdapterTools;
import de.intarsys.tools.collection.IterableTools;
import de.intarsys.tools.collection.NestedIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public abstract class CommonTrustedListManager
implements ITrustedListManager {
    private final ICertificateProvider certificateProvider = new TrustedListsCertificateProvider();

    protected CommonTrustedListManager() {
    }

    @Override
    public ICertificateProvider getCertificateProvider() {
        return this.certificateProvider;
    }

    private class TrustedListsCertificateProvider
    implements ICertificateProvider {
        private TrustedListsCertificateProvider() {
        }

        public boolean containsCertificate(IX509Certificate certificate) {
            if (certificate instanceof IX509AttributeCertificate) {
                return false;
            }
            for (ITrustedList trustedList : IterableTools.in(CommonTrustedListManager.this.lookupTrustedLists())) {
                ICertificateProvider tlCertificateProvider = (ICertificateProvider)AdapterTools.getAdapter((Object)trustedList, ICertificateProvider.class, null);
                if (tlCertificateProvider == null || !tlCertificateProvider.containsCertificate(certificate)) continue;
                return true;
            }
            return false;
        }

        public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
            IX509CertificateSelector selector;
            if (filter instanceof IX509CertificateSelector && (selector = (IX509CertificateSelector)filter).hasPrivateKey() != null && selector.hasPrivateKey().booleanValue()) {
                return Collections.emptyIterator();
            }
            ArrayList<Iterator> list = new ArrayList<Iterator>();
            for (ITrustedList trustedList : IterableTools.in(CommonTrustedListManager.this.lookupTrustedLists())) {
                ICertificateProvider tlCertificateProvider = (ICertificateProvider)AdapterTools.getAdapter((Object)trustedList, ICertificateProvider.class, null);
                if (tlCertificateProvider == null) continue;
                list.add(tlCertificateProvider.lookupCertificates(filter));
            }
            return new NestedIterator(list);
        }
    }
}

