/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.manager;

import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.tl.ITrustedList;
import de.intarsys.security.tl.ITrustedListManager;
import de.intarsys.security.tl.manager.BasicTrustedListManager;
import de.intarsys.security.validation.ValidationEnvironment;
import de.intarsys.tools.concurrent.EagerInitializable;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EagerInitializableTrustedListManager
extends EagerInitializable<ITrustedListManager>
implements ITrustedListManager {
    private static final Logger Log = LoggerFactory.getLogger(EagerInitializableTrustedListManager.class);
    private final IElement config;
    private ITrustedListManager impl;

    public EagerInitializableTrustedListManager(IElement config) {
        this.config = config;
    }

    @Override
    public ICertificateProvider getCertificateProvider() {
        return this.getImpl().getCertificateProvider();
    }

    public ITrustedListManager getImpl() {
        this.ensureInitialized();
        return this.impl;
    }

    protected ITrustedListManager initializeValue() {
        try {
            ITrustedListManager trustedListManager;
            Log.trace(this.getClass().getSimpleName() + ": realizing trust manager");
            this.impl = trustedListManager = (ITrustedListManager)ElementTools.createObject((IElement)this.config, ITrustedListManager.class, (Object)this, (IArgs)Args.create());
        }
        catch (ObjectCreationException e) {
            Log.warn("Error creating trusted list manager: " + e.getMessage(), (Throwable)e);
            this.impl = new BasicTrustedListManager();
        }
        return this.impl;
    }

    protected boolean isEagerInitializable() {
        return ValidationEnvironment.get().isPreloadCertificates();
    }

    protected boolean isInitializationRequired() {
        return true;
    }

    @Override
    public Iterator<ITrustedList> lookupTrustedLists() {
        return this.getImpl().lookupTrustedLists();
    }
}

