/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.manager;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.tl.ITrustedListPointer;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;

public class SimpleTrustedListPointer
implements ITrustedListPointer,
IElementConfigurable {
    private String location;
    private String mimeType;
    private final List<IX509PublicKeyCertificate> certificates = new ArrayList<IX509PublicKeyCertificate>();

    public SimpleTrustedListPointer() {
    }

    public SimpleTrustedListPointer(String location, String mimeType) {
        this.location = location;
        this.mimeType = mimeType;
    }

    public void addCertificate(IX509PublicKeyCertificate certificate) {
        this.certificates.add(certificate);
    }

    public void addCertificate(String base64EncodedCert) throws IOException, CertificateException {
        byte[] bCert = Base64.decode((String)base64EncodedCert);
        IX509PublicKeyCertificate certificate = X509CertificateFactory.get().createPublicKeyCertificate((InputStream)new ByteArrayInputStream(bCert));
        this.addCertificate(certificate);
    }

    public void configure(IElement element) throws ConfigurationException {
        this.setLocation(element.attributeValue("location", this.getLocation()));
        this.setMimeType(element.attributeValue("mimeType", this.getMimeType()));
        IElement eCertificates = element.element("certificates");
        if (eCertificates != null) {
            Iterator i = eCertificates.elementIterator("certificate");
            while (i.hasNext()) {
                IElement eCertificate = (IElement)i.next();
                String certificate = eCertificate.attributeValue("value", null);
                try {
                    this.addCertificate(certificate);
                }
                catch (IOException | CertificateException e) {
                    throw new ConfigurationException((Throwable)e);
                }
            }
        }
    }

    @Override
    public List<IX509PublicKeyCertificate> getCertificates() {
        return new ArrayList<IX509PublicKeyCertificate>(this.certificates);
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public PublicKey getPublicKey() {
        return null;
    }

    @Override
    public byte[] getSubjectKeyIdentifier() {
        return null;
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        return null;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

