/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.manager;

import de.intarsys.security.tl.ITrustedList;
import de.intarsys.security.tl.ITrustedListPointer;
import de.intarsys.security.tl.ITrustedListUpdater;
import de.intarsys.security.tl.manager.CommonTrustedListManager;
import de.intarsys.security.tl.manager.ITrustedListCache;
import de.intarsys.security.tl.manager.ITrustedListEntry;
import de.intarsys.security.tl.manager.SimpleTrustedListPointer;
import de.intarsys.security.tl.manager.StandardTrustedListManagerUpdater;
import de.intarsys.security.tl.manager.TrustedListDirectory;
import de.intarsys.tools.adapter.IAdapterSupport;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.progress.IProgressMonitor;
import de.intarsys.tools.progress.NullProgressMonitor;
import de.intarsys.tools.reflect.ObjectCreationException;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTrustedListManager
extends CommonTrustedListManager
implements IElementConfigurable,
IAdapterSupport {
    private static final Logger Log = LoggerFactory.getLogger(StandardTrustedListManager.class);
    private final List<ITrustedListPointer> pointers = new ArrayList<ITrustedListPointer>();
    private ITrustedListCache cache;
    protected ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public void addPointer(ITrustedListPointer pointer) {
        this.pointers.add(pointer);
    }

    public void configure(IElement element) throws ConfigurationException {
        IElement ePointers;
        IElement eCache = element.element("cache");
        if (eCache != null) {
            try {
                this.cache = (ITrustedListCache)ElementTools.createObject((IElement)eCache, ITrustedListCache.class, (Object)this, (IArgs)Args.create());
            }
            catch (ObjectCreationException e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
        if ((ePointers = element.element("pointers")) != null) {
            Iterator i = ePointers.elementIterator("pointer");
            while (i.hasNext()) {
                IElement ePointer = (IElement)i.next();
                SimpleTrustedListPointer pointer = new SimpleTrustedListPointer();
                pointer.configure(ePointer);
                this.addPointer(pointer);
            }
        }
    }

    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == ITrustedListUpdater.class) {
            return (T)new StandardTrustedListManagerUpdater(this);
        }
        return null;
    }

    public ITrustedListCache getCache() {
        if (this.cache == null) {
            this.cache = new TrustedListDirectory();
        }
        return this.cache;
    }

    public List<ITrustedListPointer> getPointers() {
        return this.pointers;
    }

    @PostConstruct
    public void load() throws IOException {
        Log.trace(this.getClass().getSimpleName() + ": enter load()");
        this.lock.writeLock().lock();
        try {
            for (ITrustedListPointer pointer : this.getPointers()) {
                this.load(pointer);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        Log.trace(this.getClass().getSimpleName() + ": leave load()");
    }

    protected void load(ITrustedListPointer pointer) throws IOException {
        Log.trace("Loading trust list from pointer to: " + pointer.getLocation());
        Log.trace("Testing cache...");
        ITrustedListEntry entry = this.getCache().getEntry(pointer);
        if (entry != null && entry.isLoaded()) {
            Log.trace("Found entry, trust list already loaded.");
            return;
        }
        Log.trace("Not cached yet. Load entry...");
        entry.load();
        if (entry.isLoaded()) {
            Log.trace("Trust list loaded. Validate...");
            entry.validate();
            Log.trace("Trust list validated.");
            if (entry.isValid()) {
                Log.trace("Trust list is valid. Load derived trust lists from contained pointers...");
                this.loadDerived(entry);
                Log.trace("Loaded derived trust lists.");
            }
        }
    }

    protected void loadDerived(ITrustedListEntry entry) throws IOException {
        for (ITrustedListPointer pointer : entry.getDerivedPointers()) {
            this.load(pointer);
        }
    }

    @Override
    public Iterator<ITrustedList> lookupTrustedLists() {
        this.lock.readLock().lock();
        try {
            Iterator<ITrustedList> iterator = this.getCache().getEntries().stream().filter(entry -> entry.isValid()).map(entry -> entry.getTrustedList()).iterator();
            return iterator;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void removePointer(ITrustedListPointer pointer) {
        this.pointers.remove(pointer);
    }

    public void setCache(ITrustedListCache directory) {
        this.cache = directory;
    }

    public void update() throws IOException {
        this.update(NullProgressMonitor.get());
    }

    public void update(IProgressMonitor progressMonitor) throws IOException {
        StandardTrustedListManagerUpdater updater = new StandardTrustedListManagerUpdater(this);
        updater.update(progressMonitor);
    }
}

