/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.manager;

import de.intarsys.security.tl.ITrustedListPointer;
import de.intarsys.security.tl.ITrustedListUpdater;
import de.intarsys.security.tl.manager.ITrustedListCache;
import de.intarsys.security.tl.manager.ITrustedListEntry;
import de.intarsys.security.tl.manager.PACKAGE;
import de.intarsys.security.tl.manager.StandardTrustedListManager;
import de.intarsys.security.tl.manager.TrustedListDirectory;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.progress.IProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardTrustedListManagerUpdater
implements ITrustedListUpdater {
    private static final Logger Log = LoggerFactory.getLogger(StandardTrustedListManagerUpdater.class);
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private StandardTrustedListManager manager;

    public StandardTrustedListManagerUpdater(StandardTrustedListManager manager) {
        this.manager = manager;
    }

    protected void collect(IProgressMonitor progressMonitor, ITrustedListCache updates, float points) throws IOException, InterruptedException {
        progressMonitor.worked(points * 0.1f);
        progressMonitor.subTask(Msg.getString("StandardTrustedListManager.ActivityCollect", new Object[0]));
        float unitSize = (points *= 0.9f) / (float)this.getManager().getPointers().size();
        HashSet<ITrustedListEntry> processed = new HashSet<ITrustedListEntry>();
        for (ITrustedListPointer pointer : this.getManager().getPointers()) {
            this.collect(pointer, progressMonitor, unitSize, updates, processed);
        }
    }

    protected void collect(ITrustedListPointer pointer, IProgressMonitor progressMonitor, float unitSize, ITrustedListCache updates, Set<ITrustedListEntry> processed) throws IOException, InterruptedException {
        if (progressMonitor.isCancelled()) {
            throw new InterruptedException("canceled");
        }
        ITrustedListEntry updateEntry = updates.getEntry(pointer);
        if (processed.contains(updateEntry)) {
            progressMonitor.worked(unitSize);
            return;
        }
        processed.add(updateEntry);
        float remainingUnitSize = unitSize;
        progressMonitor.subTask(Msg.getString("StandardTrustedListManager.ActivityUpdateFrom", new Object[]{pointer.getLocation()}));
        ITrustedListEntry entry = this.getManager().getCache().getEntry(pointer);
        if (entry.isUpdateAvailable()) {
            try {
                updateEntry.update();
                updateEntry.load();
                entry = updateEntry;
            }
            catch (IOException e) {
                Log.warn("Error updating from " + pointer.getLocation() + ": " + e.getMessage(), (Throwable)e);
            }
        }
        if (!entry.isLoaded()) {
            entry.load();
        }
        float tempSize = remainingUnitSize / 10.0f;
        progressMonitor.worked(tempSize);
        remainingUnitSize -= tempSize;
        if (entry.isLoaded()) {
            this.collectDerived(entry, progressMonitor, remainingUnitSize, updates, processed);
        }
    }

    protected void collectDerived(ITrustedListEntry entry, IProgressMonitor progressMonitor, float unitSize, ITrustedListCache updates, Set<ITrustedListEntry> processed) throws IOException, InterruptedException {
        List<ITrustedListPointer> derivedPointers = entry.getDerivedPointers();
        float pointerSize = unitSize / (float)derivedPointers.size();
        for (ITrustedListPointer pointer : derivedPointers) {
            this.collect(pointer, progressMonitor, pointerSize, updates, processed);
        }
    }

    protected File createWorkingDir() throws IOException {
        File tempDir = FileTools.createTempFile((String)("tsl_" + System.currentTimeMillis()));
        tempDir.mkdirs();
        return tempDir;
    }

    public StandardTrustedListManager getManager() {
        return this.manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(IProgressMonitor progressMonitor) throws IOException {
        int points = 4000;
        progressMonitor.begin(Msg.getString("StandardTrustedListManager.ActivityUpdating", new Object[0]), (float)points);
        File workingDir = this.createWorkingDir();
        try {
            TrustedListDirectory updates = new TrustedListDirectory((ILocator)new FileLocator(workingDir));
            this.collect(progressMonitor, updates, (float)points * 0.75f);
            this.updateFrom(updates, progressMonitor, (float)points * 0.25f);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            Log.info("Update canceled.");
        }
        finally {
            FileTools.deleteRecursivly((File)workingDir);
            progressMonitor.end();
        }
    }

    protected void update(ITrustedListPointer pointer, IProgressMonitor progressMonitor, float unitSize, ITrustedListCache updates, Set<ITrustedListEntry> processed) throws IOException, InterruptedException {
        if (progressMonitor.isCancelled()) {
            throw new InterruptedException("canceled");
        }
        ITrustedListEntry entry = this.getManager().getCache().getEntry(pointer);
        if (processed.contains(entry)) {
            progressMonitor.worked(unitSize);
            return;
        }
        processed.add(entry);
        float remainingUnitSize = unitSize;
        progressMonitor.subTask(Msg.getString("StandardTrustedListManager.ActivityUpdateFromCached", new Object[]{entry.getUrl()}));
        ITrustedListEntry updateEntry = updates.getEntry(pointer);
        if (updateEntry.isLoaded()) {
            try {
                entry.updateFrom(updateEntry);
                entry.load();
            }
            catch (IOException e) {
                Log.warn("Error updating from " + entry.getUrl() + ": " + e.getMessage(), (Throwable)e);
                this.getManager().getCache().restore(entry);
            }
        }
        if (!entry.isLoaded()) {
            entry.load();
        }
        float tempSize = remainingUnitSize / 10.0f;
        progressMonitor.worked(tempSize);
        remainingUnitSize -= tempSize;
        if (entry.isLoaded()) {
            entry.validate();
            tempSize = remainingUnitSize / 20.0f;
            progressMonitor.worked(tempSize);
            remainingUnitSize -= tempSize;
        }
        if (entry.isValid()) {
            this.updateDerived(entry, progressMonitor, remainingUnitSize, updates, processed);
        } else {
            progressMonitor.worked(remainingUnitSize);
        }
    }

    protected void updateDerived(ITrustedListEntry entry, IProgressMonitor progressMonitor, float unitSize, ITrustedListCache updates, Set<ITrustedListEntry> processed) throws IOException, InterruptedException {
        List<ITrustedListPointer> derivedPointers = entry.getDerivedPointers();
        float pointerSize = unitSize / (float)derivedPointers.size();
        for (ITrustedListPointer pointer : derivedPointers) {
            this.update(pointer, progressMonitor, pointerSize, updates, processed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateFrom(ITrustedListCache updates, IProgressMonitor progressMonitor, float points) throws IOException {
        this.getManager().lock.writeLock().lock();
        try {
            progressMonitor.subTask(Msg.getString("StandardTrustedListManager.ActivityBackup", new Object[0]));
            this.getManager().getCache().backup();
            progressMonitor.worked(points / 10.0f);
            points *= 0.9f;
            try {
                this.getManager().getCache().clear();
                progressMonitor.subTask(Msg.getString("StandardTrustedListManager.ActivityUpdate", new Object[0]));
                float unitSize = points / (float)this.getManager().getPointers().size();
                HashSet<ITrustedListEntry> processed = new HashSet<ITrustedListEntry>();
                for (ITrustedListPointer pointer : this.getManager().getPointers()) {
                    this.update(pointer, progressMonitor, unitSize, updates, processed);
                }
            }
            catch (Exception e) {
                progressMonitor.subTask(Msg.getString("StandardTrustedListManager.ActivityRestore", new Object[0]));
                try {
                    this.getManager().getCache().restore();
                    this.getManager().load();
                }
                catch (IOException ex) {
                    Log.warn("Restore failed: " + ex.getMessage(), (Throwable)ex);
                    throw new IOException(e.getMessage() + " (Restore from backup failed: )" + ex.getMessage(), e);
                }
                try {
                    throw e;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    Log.warn("Update canceled");
                }
            }
        }
        finally {
            this.getManager().lock.writeLock().unlock();
        }
    }
}

