/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.manager;

import de.intarsys.security.tl.ITrustedListPointer;
import de.intarsys.security.tl.manager.ITrustedListCache;
import de.intarsys.security.tl.manager.ITrustedListEntry;
import de.intarsys.security.tl.manager.TrustedListEntry;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.FileLocatorFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorNameFilter;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TrustedListDirectory
implements ITrustedListCache,
IElementConfigurable {
    private static final ILocatorNameFilter XMLFILTER = new ILocatorNameFilter(){

        public boolean accept(ILocator parent, String name) {
            return name.endsWith(".xml");
        }
    };
    private final Map<String, ITrustedListEntry> entries = new HashMap<String, ITrustedListEntry>();
    private ILocator baseLocator;

    public static String urlToFilename(String url) {
        Object targetName = FileTools.trimPath((String)url);
        targetName = ((String)targetName).replaceAll("[\\\\\\/]", "_");
        targetName = (String)targetName + ".xml";
        return targetName;
    }

    public TrustedListDirectory() {
    }

    public TrustedListDirectory(ILocator baseLocator) {
        this.baseLocator = baseLocator;
    }

    @Override
    public void backup() throws IOException {
        ILocator backup = this.getBackupLocator();
        if (backup.isDirectory()) {
            for (ILocator locator : backup.listLocators(XMLFILTER)) {
                locator.delete();
            }
        } else {
            new File(backup.getPath()).mkdirs();
        }
        if (this.getBaseLocator().isDirectory()) {
            for (ILocator locator : this.getBaseLocator().listLocators(XMLFILTER)) {
                LocatorTools.copy((ILocator)locator, (ILocator)backup.getChild(locator.getName()));
            }
        }
    }

    @Override
    public void clear() throws IOException {
        this.entries.clear();
    }

    public void configure(IElement element) throws ConfigurationException {
        String baseDirPath = ElementTools.getString((IElement)element, (String)"basedir", null);
        if (!StringTools.isEmpty((String)baseDirPath)) {
            try {
                ILocator locator = FileLocatorFactory.DATADIR.createLocator(baseDirPath);
                this.setBaseLocator(locator);
            }
            catch (IOException e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
    }

    protected void deleteFiles() throws IOException {
        if (this.getBaseLocator().isDirectory()) {
            for (ILocator locator : this.getBaseLocator().listLocators(XMLFILTER)) {
                locator.delete();
            }
        }
    }

    protected ILocator getBackupLocator() {
        return this.getBaseLocator().getChild("backup");
    }

    public ILocator getBaseLocator() {
        if (this.baseLocator == null) {
            File baseDir;
            try {
                baseDir = FileTools.createTempFile((String)"trustedlists");
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot create tsl temp directory");
            }
            baseDir.deleteOnExit();
            this.baseLocator = new FileLocator(baseDir);
        }
        return this.baseLocator;
    }

    @Override
    public List<ITrustedListEntry> getEntries() {
        return new ArrayList<ITrustedListEntry>(this.entries.values());
    }

    @Override
    public ITrustedListEntry getEntry(ITrustedListPointer pointer) {
        ITrustedListEntry entry = this.lookup(pointer.getLocation());
        if (entry != null) {
            return entry;
        }
        String filename = TrustedListDirectory.urlToFilename(pointer.getLocation());
        ILocator locator = this.getBaseLocator().getChild(filename);
        TrustedListEntry mEntry = new TrustedListEntry(pointer, locator);
        this.register(mEntry);
        return mEntry;
    }

    protected ITrustedListEntry lookup(String url) {
        return this.entries.get(url);
    }

    protected void register(ITrustedListEntry entry) {
        this.entries.put(entry.getUrl(), entry);
    }

    @Override
    public void restore() throws IOException {
        ILocator backup = this.getBackupLocator();
        if (!backup.isDirectory()) {
            throw new IOException("no backup available");
        }
        this.clear();
        this.deleteFiles();
        for (ILocator locator : backup.listLocators(XMLFILTER)) {
            LocatorTools.copy((ILocator)locator, (ILocator)this.getBaseLocator().getChild(locator.getName()));
        }
    }

    @Override
    public void restore(ITrustedListEntry entry) throws IOException {
        ILocator locator = ((TrustedListEntry)entry).getLocator();
        ILocator backupLocator = this.getBackupLocator().getChild(locator.getName());
        if (backupLocator.exists()) {
            LocatorTools.copy((ILocator)backupLocator, (ILocator)locator);
        }
    }

    public void setBaseLocator(ILocator baseLocator) {
        this.baseLocator = baseLocator;
    }
}

