/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.manager;

import de.intarsys.security.tl.ITrustedListPointer;
import de.intarsys.security.tl.manager.ITrustedListCache;
import de.intarsys.security.tl.manager.ITrustedListEntry;
import de.intarsys.security.tl.manager.TrustedListEntryDefaultProxy;
import de.intarsys.security.tl.manager.TrustedListReference;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TrustedListDirectoryDefaultProxy
implements ITrustedListCache,
IElementConfigurable {
    private final Map<String, ITrustedListEntry> entries = new HashMap<String, ITrustedListEntry>();
    private final Map<String, TrustedListReference> defaultEntries = new HashMap<String, TrustedListReference>();
    private ITrustedListCache impl;

    public TrustedListDirectoryDefaultProxy() {
    }

    public TrustedListDirectoryDefaultProxy(ITrustedListCache impl) {
        this.impl = impl;
    }

    public void addDefaultEntry(String url, ILocator locator) {
        TrustedListReference entryProxy = new TrustedListReference(url, locator);
        this.defaultEntries.put(url, entryProxy);
    }

    @Override
    public void backup() throws IOException {
        this.impl.backup();
    }

    @Override
    public void clear() throws IOException {
        this.entries.clear();
        this.impl.clear();
    }

    public void configure(IElement element) throws ConfigurationException {
        IElement eEntries;
        IElement eImpl = element.element("impl");
        if (eImpl != null) {
            try {
                this.impl = (ITrustedListCache)ElementTools.createObject((IElement)eImpl, ITrustedListCache.class, (Object)this, (IArgs)Args.create());
            }
            catch (ObjectCreationException e) {
                throw new ConfigurationException((Throwable)e);
            }
        }
        if ((eEntries = element.element("entries")) != null) {
            Iterator i = eEntries.elementIterator("entry");
            while (i.hasNext()) {
                ILocator locator;
                IElement eEntry = (IElement)i.next();
                String url = eEntry.attributeValue("url", null);
                try {
                    locator = LocatorFactory.get().createLocator(eEntry.attributeValue("locator", null));
                }
                catch (IOException e) {
                    throw new ConfigurationException((Throwable)e);
                }
                this.addDefaultEntry(url, locator);
            }
        }
    }

    public TrustedListReference getDefaultDefinition(String url) {
        return this.defaultEntries.get(url);
    }

    public Map<String, TrustedListReference> getDefaultDefinitions() {
        return new HashMap<String, TrustedListReference>(this.defaultEntries);
    }

    @Override
    public List<ITrustedListEntry> getEntries() {
        return new ArrayList<ITrustedListEntry>(this.entries.values());
    }

    @Override
    public ITrustedListEntry getEntry(ITrustedListPointer pointer) {
        String location = pointer.getLocation();
        ITrustedListEntry entry = this.lookup(location);
        if (entry != null) {
            return entry;
        }
        entry = this.impl.getEntry(pointer);
        TrustedListReference defaultDefinition = this.getDefaultDefinition(location);
        if (defaultDefinition == null) {
            this.register(entry);
        } else {
            TrustedListEntryDefaultProxy entryProxy = new TrustedListEntryDefaultProxy(defaultDefinition, entry);
            this.register(entryProxy);
            entry = entryProxy;
        }
        return entry;
    }

    public ITrustedListCache getImpl() {
        return this.impl;
    }

    protected ITrustedListEntry lookup(String url) {
        return this.entries.get(url);
    }

    protected void register(ITrustedListEntry entry) {
        this.entries.put(entry.getUrl(), entry);
    }

    @Override
    public void restore() throws IOException {
        this.entries.clear();
        this.impl.restore();
    }

    @Override
    public void restore(ITrustedListEntry entry) throws IOException {
        if (entry instanceof TrustedListEntryDefaultProxy) {
            entry = ((TrustedListEntryDefaultProxy)entry).getImpl();
        }
        this.impl.restore(entry);
    }

    public void setImpl(ITrustedListCache impl) {
        this.impl = impl;
    }
}

