/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.manager;

import de.intarsys.security.tl.ITrustedListPointer;
import de.intarsys.security.tl.manager.CommonTrustedListEntry;
import de.intarsys.security.tl.manager.ITrustedListEntry;
import de.intarsys.security.tl.tools.TSLRemoteTarget;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorTools;
import java.io.IOException;

public class TrustedListEntry
extends CommonTrustedListEntry
implements ILocatorSupport {
    private final ITrustedListPointer pointer;
    private final ILocator locator;

    public TrustedListEntry(ITrustedListPointer pointer, ILocator locator) {
        this.pointer = pointer;
        this.locator = locator;
    }

    @Override
    public ILocator getLocator() {
        return this.locator;
    }

    @Override
    public ITrustedListPointer getPointer() {
        return this.pointer;
    }

    @Override
    public String getUrl() {
        return this.getPointer().getLocation();
    }

    @Override
    public void update() throws IOException {
        TSLRemoteTarget.DownloadResult downloadResult = this.getTSLTarget().download();
        LocatorTools.write((ILocator)this.getLocator(), (byte[])downloadResult.getData());
        this.reset();
    }

    @Override
    public void updateFrom(ITrustedListEntry entry) throws IOException {
        ILocator locator = null;
        if (entry instanceof ILocatorSupport) {
            locator = ((ILocatorSupport)entry).getLocator();
        }
        LocatorTools.copy((ILocator)locator, (ILocator)this.getLocator());
        this.reset();
    }
}

