/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.manager;

import de.intarsys.security.tl.ITrustedList;
import de.intarsys.security.tl.ITrustedListPointer;
import de.intarsys.security.tl.manager.ITrustedListEntry;
import de.intarsys.security.tl.manager.TrustedListDefaultEntry;
import de.intarsys.security.tl.manager.TrustedListReference;
import de.intarsys.security.tl.validation.IVSTrustedList;
import java.io.IOException;
import java.util.Date;
import java.util.List;

public class TrustedListEntryDefaultProxy
implements ITrustedListEntry {
    private final ITrustedListEntry impl;
    private final TrustedListDefaultEntry defaultImpl;
    private ITrustedListEntry current;

    public TrustedListEntryDefaultProxy(TrustedListReference definition, ITrustedListEntry impl) {
        this.impl = impl;
        this.defaultImpl = new TrustedListDefaultEntry(impl.getPointer(), definition);
    }

    protected ITrustedListEntry determineCurrent() {
        if (this.impl.isLoaded()) {
            Date implIssueDate = null;
            Date defaultIssueDate = null;
            if (this.impl.getTrustedList() != null) {
                implIssueDate = this.impl.getTrustedList().getDateIssued();
            }
            if (this.defaultImpl.getTrustedList() != null) {
                defaultIssueDate = this.defaultImpl.getTrustedList().getDateIssued();
            }
            if (!defaultIssueDate.after(implIssueDate)) {
                return this.impl;
            }
        }
        return this.defaultImpl;
    }

    protected ITrustedListEntry getCurrent() {
        if (this.current == null) {
            this.current = this.determineCurrent();
        }
        return this.current;
    }

    protected TrustedListReference getDefinition() {
        return this.defaultImpl.getDefinition();
    }

    @Override
    public List<ITrustedListPointer> getDerivedPointers() {
        return this.getCurrent().getDerivedPointers();
    }

    public ITrustedListEntry getImpl() {
        return this.impl;
    }

    @Override
    public ITrustedListPointer getPointer() {
        return this.impl.getPointer();
    }

    @Override
    public ITrustedList getTrustedList() {
        return this.getCurrent().getTrustedList();
    }

    @Override
    public String getUrl() {
        return this.getDefinition().getUrl();
    }

    @Override
    public boolean isLoaded() {
        return this.impl.isLoaded() || this.defaultImpl.isLoaded();
    }

    @Override
    public boolean isUpdateAvailable() {
        return this.getCurrent().isUpdateAvailable();
    }

    @Override
    public boolean isValid() {
        return this.getCurrent().isValid();
    }

    @Override
    public void load() throws IOException {
        this.impl.load();
        this.defaultImpl.load();
    }

    @Override
    public void update() throws IOException {
        this.impl.update();
        this.current = null;
    }

    @Override
    public void updateFrom(ITrustedListEntry entry) throws IOException {
        this.impl.updateFrom(entry);
        this.current = null;
    }

    @Override
    public IVSTrustedList validate() {
        return this.getCurrent().validate();
    }
}

