/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.tools;

import de.intarsys.security.tl.ITrustedListPointer;
import de.intarsys.security.tl.impl.TrustedList;
import de.intarsys.security.tl.manager.TrustedListReference;
import de.intarsys.security.tl.tools.TSLRemoteTarget;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.expression.DynamicArgsResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.TaggedStringEvaluator;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.servicelocator.ServiceLocator;
import de.intarsys.tools.ssl.ConfigurableSslContextProvider;
import de.intarsys.tools.ssl.ConfigurableTrustManagerProvider;
import de.intarsys.tools.ssl.ISslContextProvider;
import de.intarsys.tools.ssl.ITrustManagerProvider;
import java.io.File;
import java.io.IOException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSLDownloader {
    private static final Logger Log = LoggerFactory.getLogger(TSLDownloader.class);
    private String location;
    private ILocator targetDirectory;
    private boolean downloadReferenced;
    private String fileNameTemplate = "${tsl.territory} - ${tsl.operatorName}.xml";
    private IStringEvaluator evaluator;

    public static void main(String[] args) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        TSLDownloader.setupSSLTrustAll();
        TSLDownloader downloader = new TSLDownloader();
        downloader.setTargetDirectory((ILocator)new FileLocator(new File("work")));
        downloader.setLocation("https://ec.europa.eu/information_society/policy/esignature/trusted-list/tl-mp.xml");
        downloader.setDownloadReferenced(true);
        try {
            downloader.download();
        }
        catch (IOException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public static void setupSSLTrustAll() {
        ServiceLocator.get().put(ISslContextProvider.class, (Object)new ConfigurableSslContextProvider());
        ServiceLocator.get().put(ITrustManagerProvider.class, (Object)ConfigurableTrustManagerProvider.createGullible());
    }

    protected boolean contains(List<TrustedListReference> downloaded, String url) {
        Optional<TrustedListReference> contained = downloaded.stream().filter(ref -> ref.getUrl().equals(url)).findAny();
        return contained.isPresent();
    }

    protected String createFileName(TrustedList tsl, boolean collision) throws EvaluationException {
        Args args = Args.create();
        args.put("tsl", (Object)tsl);
        args.put("collision", (Object)collision);
        String targetName = (String)this.getEvaluator().evaluate(this.getFileNameTemplate(), (IArgs)args);
        targetName = FileTools.trimPath((String)targetName);
        targetName = targetName.replaceAll("[\\\\\\/]", "_");
        return targetName;
    }

    public List<TrustedListReference> download() throws IOException {
        ArrayList<TrustedListReference> downloaded = new ArrayList<TrustedListReference>();
        this.download(downloaded);
        return downloaded;
    }

    public void download(List<TrustedListReference> downloaded) throws IOException {
        this.downloadAndSave(this.getLocation(), this.isDownloadReferenced(), downloaded);
    }

    protected TrustedList downloadAndSave(String url, boolean downloadReferenced, List<TrustedListReference> downloaded) throws IOException {
        String targetName;
        TSLRemoteTarget tslTarget = new TSLRemoteTarget(url);
        Log.info("Downloading digest for " + url);
        IDigest digest = tslTarget.getDigest();
        if (digest == null) {
            Log.info("digest not available");
        } else {
            Log.info("digest downloaded, value is " + new String(Base64.encode((byte[])digest.getBytes())));
        }
        Log.info("Downloading TSL from " + url);
        TSLRemoteTarget.DownloadResult downloadResult = tslTarget.download();
        byte[] tslData = downloadResult.getData();
        ByteArrayLocator lTsl = new ByteArrayLocator(tslData, "tsl.xml");
        TrustedList tsl = TrustedList.create((ILocator)lTsl);
        try {
            targetName = this.createFileName(tsl, false);
        }
        catch (EvaluationException e) {
            throw new IOException(e);
        }
        ILocator targetLocator = this.getTargetDirectory().getChild(targetName);
        if (targetLocator.exists()) {
            try {
                targetName = this.createFileName(tsl, true);
            }
            catch (EvaluationException e) {
                throw new IOException(e);
            }
            targetLocator = this.getTargetDirectory().getChild(targetName);
        }
        LocatorTools.copy((ILocator)lTsl, (ILocator)targetLocator);
        downloaded.add(new TrustedListReference(url, targetLocator));
        if (downloadReferenced) {
            for (ITrustedListPointer pointer : tsl.getTSLPointers()) {
                String pUrl;
                String mimeType = pointer.getMimeType();
                if (mimeType != null && !"application/vnd.etsi.tsl+xml".equals(mimeType) || this.contains(downloaded, pUrl = pointer.getLocation())) continue;
                try {
                    this.downloadAndSave(pUrl, true, downloaded);
                }
                catch (IOException e) {
                    Log.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        return tsl;
    }

    protected IStringEvaluator getEvaluator() {
        if (this.evaluator == null) {
            this.evaluator = TaggedStringEvaluator.decorate((IStringEvaluator[])new IStringEvaluator[]{new DynamicArgsResolver()});
        }
        return this.evaluator;
    }

    public String getFileNameTemplate() {
        return this.fileNameTemplate;
    }

    public String getLocation() {
        return this.location;
    }

    public ILocator getTargetDirectory() {
        return this.targetDirectory;
    }

    public boolean isDownloadReferenced() {
        return this.downloadReferenced;
    }

    public void setDownloadReferenced(boolean downloadReferenced) {
        this.downloadReferenced = downloadReferenced;
    }

    public void setFileNameTemplate(String fileNameTemplate) {
        this.fileNameTemplate = fileNameTemplate;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setTargetDirectory(ILocator targetDirectory) {
        this.targetDirectory = targetDirectory;
    }
}

