/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.tools;

import de.intarsys.remote.core.RemoteCallConfigurationException;
import de.intarsys.remote.http.rpc.HttpRemoteContext;
import de.intarsys.security.tl.manager.TrustedListDirectory;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigestSupport;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSLRemoteTarget
implements IDigestSupport {
    private static final Logger Log = LoggerFactory.getLogger(TSLRemoteTarget.class);
    private String url;
    private String digestUrl;

    public TSLRemoteTarget(String url) {
        this.url = url;
    }

    /*
     * Loose catch block
     */
    protected DownloadResult basicDownload(String url, int connectTimeout, int readTimeout) throws IOException {
        HttpResponse response;
        HttpRemoteContext context;
        HttpEntity entity;
        block10: {
            entity = null;
            context = new HttpRemoteContext();
            context.setConnectionTimeout(connectTimeout);
            context.setSocketTimeout(readTimeout);
            context.setSslCertificateVerification(false);
            context.setSslHostVerification(false);
            HttpGet method = new HttpGet(url);
            HttpClient client = context.getHttpClient();
            response = client.execute((HttpUriRequest)method);
            entity = response.getEntity();
            if (response.getStatusLine().getStatusCode() != 200) break block10;
            byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
            DownloadResult result = new DownloadResult(bytes, this.getUrl());
            result.setContentType(entity.getContentType() == null ? null : entity.getContentType().getValue());
            result.setContentEncoding(entity.getContentEncoding() == null ? null : entity.getContentEncoding().getValue());
            DownloadResult downloadResult = result;
            context.close();
            EntityUtils.consumeQuietly((HttpEntity)entity);
            return downloadResult;
        }
        try {
            try {
                throw new IOException("HTTP GET failed with: " + response.getStatusLine());
                {
                    catch (Throwable throwable) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
            catch (RemoteCallConfigurationException e) {
                throw new IOException(e);
            }
        }
        catch (Throwable throwable) {
            EntityUtils.consumeQuietly(entity);
            throw throwable;
        }
    }

    protected String deriveDigestUrl() {
        Object digestUrl = this.getUrl();
        digestUrl = ((String)digestUrl).endsWith(".xml") ? ((String)digestUrl).substring(0, ((String)digestUrl).length() - 4) + ".sha2" : (String)digestUrl + ".sha2";
        return digestUrl;
    }

    public DownloadResult download() throws IOException {
        return this.basicDownload(this.getUrl(), 5000, 30000);
    }

    public IDigest getDigest() {
        String digestUrl = this.getDigestUrl();
        try {
            DownloadResult downloadResult = this.basicDownload(digestUrl, 1000, 3000);
            byte[] digestData = downloadResult.getData();
            if (digestData.length == 64) {
                digestData = HexTools.hexStringToBytes((String)new String(digestData));
            }
            return DigestTools.createDigest((String)"SHA-256", (byte[])digestData);
        }
        catch (Exception e) {
            Log.trace("Cannot read digest for {} ({})", (Object)this.getUrl(), (Object)e.getMessage());
            return null;
        }
    }

    public String getDigestUrl() {
        if (this.digestUrl == null) {
            this.digestUrl = this.deriveDigestUrl();
        }
        return this.digestUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setDigestUrl(String digestUrl) {
        this.digestUrl = digestUrl;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public static class DownloadResult {
        private final byte[] data;
        private String contentType;
        private String contentEncoding;
        private String source;

        public DownloadResult(byte[] data, String source) {
            this.data = data;
            this.source = source;
        }

        public String getContentEncoding() {
            return this.contentEncoding;
        }

        public String getContentType() {
            return this.contentType;
        }

        public byte[] getData() {
            return this.data;
        }

        public String getSource() {
            return this.source;
        }

        public void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public ILocator toLocator() {
            return new ByteArrayLocator(this.getData(), TrustedListDirectory.urlToFilename(this.getSource()));
        }
    }
}

