/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.validation;

import de.intarsys.security.app.validation.ISignatureContainerValidator;
import de.intarsys.security.app.validation.IValidationContext;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.common.ValidationContext;
import de.intarsys.security.app.validation.commonpki.CommonPKIValidationContextFactory;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.VSDefault;
import de.intarsys.security.standard.validation.VSSignatureContainer;
import de.intarsys.security.standard.validation.ValidationMessage;
import de.intarsys.security.tl.ITrustedList;
import de.intarsys.security.tl.impl.TrustedListTools;
import de.intarsys.security.tl.validation.ITrustedListValidator;
import de.intarsys.security.tl.validation.IVSTrustedList;
import de.intarsys.security.tl.validation.VSTrustedList;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustedListValidator
implements ITrustedListValidator {
    private static final Logger Log = LoggerFactory.getLogger(TrustedListValidator.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IVSTrustedList validate(ITrustedList trustedList, IValidationParameters parameters) {
        VSTrustedList result = new VSTrustedList(trustedList, 0);
        Args args = Args.create();
        args.put("acceptIntermediateTrustAnchor", (Object)true);
        args.put("stopOnIntermediateTrustAnchor", (Object)true);
        args.put("checkOCSP", (Object)false);
        args.put("checkCRL", (Object)false);
        CommonPKIValidationContextFactory contextFactory = new CommonPKIValidationContextFactory();
        IValidationContext previousContext = ValidationContext.getCurrent();
        IValidationContext context = contextFactory.createValidationContext((IArgs)args);
        try {
            IVSSignatureContainer signatureState = null;
            ISignatureContainerValidator validator = context.getSignatureContainerValidator();
            try {
                ISignatureContainer signatureContainer = trustedList.getSignatureContainer();
                signatureState = validator.validate(signatureContainer, null, parameters);
            }
            catch (IOException e) {
                Log.trace(e.getMessage(), (Throwable)e);
                signatureState = new VSSignatureContainer(null, 3);
                ((VSSignatureContainer)signatureState).addMessage(CommonValidationMessages.ERROR_IO((Exception)e));
            }
            result.setSignatureState(signatureState);
            VSDefault validityPeriodState = new VSDefault(0);
            validityPeriodState.setSeverity(1);
            Date nextUpdate = trustedList.getDateNextUpdate();
            if (nextUpdate != null && nextUpdate.before(new Date())) {
                validityPeriodState.increaseState(3);
                validityPeriodState.addMessage(ValidationMessage.createError((String)("Trusted List '" + TrustedListTools.getLabel(trustedList) + "': Next update lies in the past (" + DateFormat.getDateTimeInstance().format(nextUpdate) + "). Should update trusted list.")));
            }
            result.setValidityPeriodState((IValidationState)validityPeriodState);
            VSTrustedList vSTrustedList = result;
            return vSTrustedList;
        }
        finally {
            ValidationContext.setCurrent((IValidationContext)previousContext);
        }
    }
}

