/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.tl.validation;

import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.standard.validation.CommonValidationState;
import de.intarsys.security.standard.validation.DefaultValidationTarget;
import de.intarsys.security.standard.validation.VSDefault;
import de.intarsys.security.standard.validation.VSSignatureContainer;
import de.intarsys.security.tl.ITrustedList;
import de.intarsys.security.tl.validation.IVSTrustedList;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IValidationState;
import de.intarsys.security.validation.IValidationTarget;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VSTrustedList
extends CommonValidationState
implements IVSTrustedList {
    private static final Logger Log = LoggerFactory.getLogger(VSTrustedList.class);
    private IVSSignatureContainer signatureState;
    private IValidationState validityPeriodState;

    public VSTrustedList(ITrustedList trustedList) {
        super((IValidationTarget)new DefaultValidationTarget((Object)trustedList));
    }

    public VSTrustedList(ITrustedList trustedList, int state) {
        super((IValidationTarget)new DefaultValidationTarget((Object)trustedList), state);
    }

    public VSTrustedList(IVSTrustedList state) {
        super((IValidationState)state);
    }

    protected void copy(IValidationState state) {
        super.copy(state);
        IVSTrustedList tlState = (IVSTrustedList)state;
        this.signatureState = tlState.getSignatureState();
        this.validityPeriodState = tlState.getValidityPeriodState();
    }

    @Override
    public IVSSignatureContainer getSignatureState() {
        if (this.signatureState == null) {
            ISignatureContainer signatureContainer = null;
            try {
                signatureContainer = this.getTrustedList().getSignatureContainer();
            }
            catch (IOException e) {
                Log.trace(e.getMessage(), (Throwable)e);
            }
            this.signatureState = new VSSignatureContainer(signatureContainer);
        }
        return this.signatureState;
    }

    public ITrustedList getTrustedList() {
        return (ITrustedList)this.getValidationTarget().getImpl();
    }

    @Override
    public IValidationState getValidityPeriodState() {
        if (this.validityPeriodState == null) {
            this.validityPeriodState = new VSDefault();
        }
        return this.validityPeriodState;
    }

    public void setSignatureState(IVSSignatureContainer pSignatureState) {
        this.signatureState = pSignatureState;
        this.increaseState((IValidationState)pSignatureState);
    }

    public void setValidityPeriodState(IValidationState validityPeriodState) {
        this.validityPeriodState = validityPeriodState;
        this.increaseState(validityPeriodState);
    }

    public String toString() {
        StringBuilder b = new StringBuilder(super.toString());
        b.append("--- start signature state ---\n");
        b.append(this.indent(String.valueOf(this.getSignatureState())));
        b.append("--- end signature state ---\n");
        b.append("--- start validity period state ---\n");
        b.append(this.indent(String.valueOf(this.getValidityPeriodState())));
        b.append("--- end validity period state ---\n");
        return b.toString();
    }
}

