/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.html;

import de.intarsys.html.IStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompositeStyle
implements IStyle {
    private List<IStyle> styles = new ArrayList<IStyle>();

    public void addStyle(IStyle style) {
        this.styles.add(style);
    }

    @Override
    public boolean containsPropertyValue(String propertyName, String propertyValue) {
        String definedValue = this.getPropertyValue(propertyName);
        if (definedValue == null) {
            return false;
        }
        return definedValue.equals(propertyValue);
    }

    @Override
    public String getCssText() {
        return "";
    }

    @Override
    public String getPropertyValue(String propertyName) {
        for (IStyle style : this.styles) {
            String value = style.getPropertyValue(propertyName);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public List<String> getPropertyValues(String propertyName) {
        for (IStyle style : this.styles) {
            List<String> value = style.getPropertyValues(propertyName);
            if (value == null || value.isEmpty()) continue;
            return value;
        }
        return Collections.emptyList();
    }

    public void removeStyle(IStyle style) {
        this.styles.remove(style);
    }
}

