/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.html.impl;

import de.intarsys.html.IHtmlHandler;
import de.intarsys.html.IHtmlTag;
import de.intarsys.html.IHtmlTagImpl;
import de.intarsys.html.IHtmlTagImplFactory;
import de.intarsys.html.IStyleSheet;
import de.intarsys.html.IStyleSheetParser;
import de.intarsys.html.impl.steadystate.SteadyStateStyleSheetParser;
import java.util.Stack;

public abstract class AbstractHtmlHandler
implements IHtmlHandler {
    private IStyleSheetParser styleSheetParser;
    private IStyleSheet styleSheet = null;
    private Stack tagStack = new Stack();
    private IHtmlTagImplFactory tagImplFactory;

    public AbstractHtmlHandler(IHtmlTagImplFactory tagImplFactory) {
        this.tagImplFactory = tagImplFactory;
    }

    protected IStyleSheetParser createDefaultStyleSheetParser() {
        return new SteadyStateStyleSheetParser();
    }

    protected abstract IHtmlTagImpl createRootElement() throws Exception;

    @Override
    public void endDocument() throws Exception {
    }

    @Override
    public void endTag(IHtmlTag tag) throws Exception {
        this.getCurrentTag().ended();
        IHtmlTagImpl oldTag = (IHtmlTagImpl)this.getTagStack().pop();
        this.getCurrentTag().end(oldTag);
    }

    @Override
    public IHtmlTagImpl getCurrentTag() {
        return (IHtmlTagImpl)this.getTagStack().peek();
    }

    @Override
    public IStyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    @Override
    public IStyleSheetParser getStyleSheetParser() {
        if (this.styleSheetParser == null) {
            this.styleSheetParser = this.createDefaultStyleSheetParser();
        }
        return this.styleSheetParser;
    }

    public IHtmlTagImplFactory getTagImplFactory() {
        return this.tagImplFactory;
    }

    protected Stack getTagStack() {
        return this.tagStack;
    }

    @Override
    public void setStyleSheet(IStyleSheet styleSheet) {
        if (this.getStyleSheet() != null) {
            return;
        }
        this.styleSheet = styleSheet;
    }

    public void setStyleSheetParser(IStyleSheetParser styleSheetParser) {
        this.styleSheetParser = styleSheetParser;
    }

    @Override
    public void startDocument() throws Exception {
        IHtmlTagImpl rootTag = this.createRootElement();
        this.tagStack.push(rootTag);
        this.getCurrentTag().started();
    }

    @Override
    public void startTag(IHtmlTag tag) throws Exception {
        IHtmlTagImpl newTag = this.getCurrentTag().start(tag);
        this.getTagStack().push(newTag);
        this.getCurrentTag().started();
    }

    @Override
    public void text(char[] data, int start, int length) throws Exception {
        this.getCurrentTag().text(data, start, length);
    }
}

