/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.html.impl;

import de.intarsys.html.IHtmlTag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HtmlTag
implements IHtmlTag {
    private String name;
    private Map attributes = new HashMap();
    private boolean isBlock;
    private boolean isBreak;

    public HtmlTag(String name) {
        this(name, false, false);
    }

    public HtmlTag(String name, boolean isBlock, boolean isBreak) {
        this.name = name.toLowerCase();
        this.setBlock(isBlock);
        this.setBreak(isBreak);
    }

    @Override
    public boolean containsAttribute(String name) {
        return this.getAttributes().containsKey(name);
    }

    @Override
    public String getAttribute(String name) {
        return (String)this.getAttributes().get(name);
    }

    @Override
    public boolean getAttributeAsBoolean(String name, boolean defaultValue) {
        String value = this.getAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return Boolean.valueOf(value);
    }

    @Override
    public double getAttributeAsDouble(String name, double defaultValue) {
        String value = this.getAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return Double.parseDouble(value);
    }

    @Override
    public int getAttributeAsInteger(String name, int defaultValue) {
        String value = this.getAttribute(name);
        if (value == null) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    @Override
    public List getAttributeNames() {
        return new ArrayList(this.getAttributes().keySet());
    }

    @Override
    public Map getAttributes() {
        return this.attributes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isBlock() {
        return this.isBlock;
    }

    @Override
    public boolean isBreak() {
        return this.isBreak;
    }

    public void setAttribute(String name, String value) {
        this.getAttributes().put(name.toLowerCase(), value);
    }

    public void setBlock(boolean isBlock) {
        this.isBlock = isBlock;
    }

    public void setBreak(boolean isBreak) {
        this.isBreak = isBreak;
    }
}

