/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.html.impl.steadystate;

import de.intarsys.html.IStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.css.CSSStyleDeclaration;

public class SteadyStateStyle
implements IStyle {
    private CSSStyleDeclaration impl;

    public SteadyStateStyle(CSSStyleDeclaration impl) {
        this.impl = impl;
    }

    @Override
    public boolean containsPropertyValue(String propertyName, String propertyValue) {
        String definedValue = this.getPropertyValue(propertyName);
        if (definedValue == null) {
            return false;
        }
        return definedValue.equals(propertyValue);
    }

    @Override
    public String getCssText() {
        return this.getImpl().getCssText();
    }

    public CSSStyleDeclaration getImpl() {
        return this.impl;
    }

    @Override
    public String getPropertyValue(String propertyName) {
        String result = this.getImpl().getPropertyValue(propertyName);
        if (result == null || result.length() == 0) {
            return null;
        }
        return result;
    }

    @Override
    public List<String> getPropertyValues(String propertyName) {
        String value = this.getPropertyValue(propertyName);
        if (value == null || value.length() == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(value, " ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ((token = token.trim()).length() <= 0) continue;
            result.add(token);
        }
        return result;
    }
}

