/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.html.impl.steadystate;

import com.steadystate.css.dom.CSSStyleRuleImpl;
import com.steadystate.css.parser.selectors.IMatcher;
import com.steadystate.css.parser.selectors.Match;
import de.intarsys.html.IStyle;
import de.intarsys.html.IStyleSheet;
import de.intarsys.html.impl.steadystate.SteadyStateStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;

public class SteadyStateStyleSheet
implements IStyleSheet {
    private CSSStyleSheet impl;

    public SteadyStateStyleSheet(CSSStyleSheet impl) {
        this.impl = impl;
    }

    public CSSStyleSheet getImpl() {
        return this.impl;
    }

    @Override
    public IStyle getStyle(String tag, Map attributes) {
        Match currentMatch = null;
        CSSStyleDeclaration currentStyle = null;
        for (CSSStyleRuleImpl rule : this.getStyleRules()) {
            Match match;
            if (!(rule instanceof IMatcher) || (match = rule.match(tag, attributes)) == null || currentMatch != null && !match.supersedes(currentMatch)) continue;
            currentMatch = match;
            currentStyle = rule.getStyle();
        }
        if (currentStyle == null) {
            return null;
        }
        return new SteadyStateStyle(currentStyle);
    }

    protected List getStyleRules() {
        ArrayList<CSSRule> result = new ArrayList<CSSRule>();
        CSSRuleList rules = this.getImpl().getCssRules();
        for (int i = 0; i < rules.getLength(); ++i) {
            CSSRule rule = rules.item(i);
            if (rule.getType() != 1) continue;
            result.add(rule);
        }
        return result;
    }
}

