/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.html.impl.tagsoup;

import de.intarsys.html.IHtmlHandler;
import de.intarsys.html.impl.AbstractHtmlParser;
import de.intarsys.html.impl.HtmlTag;
import java.io.IOException;
import java.io.Reader;
import javax.swing.text.html.HTML;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TagSoupParser
extends AbstractHtmlParser {
    public TagSoupParser(IHtmlHandler handler) {
        super(handler);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.getHandler().text(ch, start, length);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.getHandler().endDocument();
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        HtmlTag tag = new HtmlTag(localName);
        try {
            this.getHandler().endTag(tag);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    @Override
    public void parse(Reader in) throws IOException {
        try {
            DefaultHandler contentHandler = new DefaultHandler(){

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    TagSoupParser.this.characters(ch, start, length);
                }

                @Override
                public void endDocument() throws SAXException {
                    TagSoupParser.this.endDocument();
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    TagSoupParser.this.endElement(uri, localName, qName);
                }

                @Override
                public void startDocument() throws SAXException {
                    TagSoupParser.this.startDocument();
                }

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    TagSoupParser.this.startElement(uri, localName, qName, attributes);
                }
            };
            Parser parser = new Parser();
            parser.setContentHandler((ContentHandler)contentHandler);
            parser.parse(new InputSource(in));
        }
        catch (SAXException e) {
            if (e.getException() != null) {
                throw new IOException(e.getMessage(), e.getException());
            }
            throw new IOException(e.getMessage(), e);
        }
    }

    public void startDocument() throws SAXException {
        try {
            this.getHandler().startDocument();
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        HtmlTag tag = new HtmlTag(localName);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String attrName = attributes.getLocalName(i);
            String attrValue = attributes.getValue(i);
            tag.setAttribute(attrName, attrValue);
        }
        HTML.Tag swingTag = HTML.getTag(localName);
        if (swingTag != null) {
            tag.setBlock(swingTag.isBlock());
            tag.setBreak(swingTag.breaksFlow());
        }
        try {
            this.getHandler().startTag(tag);
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }
}

