/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.conversation.service.impl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.intarsys.conversation.service.client.api.DtoCancelStage;
import de.intarsys.conversation.service.client.api.DtoConversationSnapshot;
import de.intarsys.conversation.service.client.api.DtoErrorDetail;
import de.intarsys.conversation.service.client.api.DtoErrorStage;
import de.intarsys.conversation.service.client.api.DtoHttpRedirectStage;
import de.intarsys.conversation.service.client.api.DtoIdleStage;
import de.intarsys.conversation.service.client.api.DtoProcessingStage;
import de.intarsys.conversation.service.client.api.DtoReplyStage;
import de.intarsys.conversation.service.client.api.DtoRequestInputStage;
import de.intarsys.conversation.service.client.api.DtoResultStage;
import de.intarsys.conversation.service.client.api.IntegrationOptions;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.conversation.ConversationRegistry;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.CancelStage;
import de.intarsys.tools.conversation.impl.ErrorStage;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.conversation.impl.IdleStage;
import de.intarsys.tools.conversation.impl.ProcessingStage;
import de.intarsys.tools.conversation.impl.RequestInputStage;
import de.intarsys.tools.conversation.impl.ResultStage;
import de.intarsys.tools.jaxrs.RequestContext;
import de.intarsys.tools.loadbalance.LoadBalanceContext;
import de.intarsys.tools.net.IUriProvider;
import de.intarsys.tools.string.StringTools;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationServiceTools {
    private static final Logger Log = LoggerFactory.getLogger(ConversationServiceTools.class);
    private static final boolean NO_LINKS = Boolean.getBoolean("de.intarsys.conversation.snapshot.noLinks");
    public static final String PARAM_STAGE = "stage";
    public static final String PARAM_REDIRECT_URI = "redirectUri";
    public static final String PARAM_CONVERSATION = "conversation";
    public static final String PARAM_CS_OUTCOME = "cs_outcome";
    public static final String PARAM_CS_STAGE = "cs_stage";
    public static final String PARAM_CS_CONVERSATION = "cs_conversation";
    private static final Object ATTR_INTEGRATION_OPTIONS = new Attribute("integrationOptions");
    private static final Object ATTR_OOB_ACTIVE = new Attribute("oobActive");
    private static final Object ATTR_ROOT_CONVERSATION = new Attribute("root");
    private static final Object ATTR_PARAMETERS = "parameters";
    public static final String PATH_CONVERSATION_PREFIX = "api/v1/flow/conversation";
    private static IUriProvider CaptureProvider = new IUriProvider(){

        public URI getUri() {
            return URI.create("api/v1/flow/conversation/capture");
        }
    };
    private static boolean LegacyIntegrationSupport = false;
    private static final ObjectMapper MAPPER = new ObjectMapper();

    public static DtoConversationSnapshot createDtoConversationSnapshot(IConversation<?> conversation, DtoReplyStage dtoStage) {
        DtoConversationSnapshot snapshot = new DtoConversationSnapshot();
        snapshot.setConversationHandle(conversation.getHandle());
        snapshot.setReplyStage(dtoStage);
        if (!dtoStage.isFinal() && !NO_LINKS) {
            UriBuilder uriBuilder = RequestContext.get().getUriBuilderContext().path(PATH_CONVERSATION_PREFIX).path("acknowledge");
            snapshot.setLink("acknowledge", uriBuilder.build(new Object[0]).toString());
            uriBuilder = RequestContext.get().getUriBuilderContext().path(PATH_CONVERSATION_PREFIX).path("cancel");
            snapshot.setLink("cancel", uriBuilder.build(new Object[0]).toString());
        }
        return snapshot;
    }

    public static DtoReplyStage createDtoReplyStage(IConversation<?> conversation, IReplyStage replyStage) {
        if (replyStage instanceof CancelStage) {
            CancelStage realStage = (CancelStage)replyStage;
            DtoCancelStage resultStage = new DtoCancelStage();
            resultStage.setId(realStage.getId());
            return resultStage;
        }
        if (replyStage instanceof ErrorStage) {
            ErrorStage realStage = (ErrorStage)replyStage;
            DtoErrorStage resultStage = new DtoErrorStage();
            resultStage.setId(realStage.getId());
            DtoErrorDetail resultErrorDetail = DtoErrorDetail.createGears((Throwable)realStage.getThrowable());
            resultStage.setError(resultErrorDetail);
            return resultStage;
        }
        if (replyStage instanceof HttpRedirectStage) {
            HttpRedirectStage realStage = (HttpRedirectStage)replyStage;
            DtoHttpRedirectStage resultStage = new DtoHttpRedirectStage();
            resultStage.setId(realStage.getId());
            resultStage.setName(realStage.getName());
            resultStage.setOutOfBand(realStage.isOutOfBand());
            resultStage.setSpecs(realStage.getSpecs());
            resultStage.setPrint(realStage.getPrint());
            resultStage.setUrl(ConversationServiceTools.getHttpRedirectTargetUri(conversation, realStage));
            return resultStage;
        }
        if (replyStage instanceof IdleStage) {
            IdleStage realStage = (IdleStage)replyStage;
            DtoIdleStage resultStage = new DtoIdleStage();
            resultStage.setId(realStage.getId());
            return resultStage;
        }
        if (replyStage instanceof ProcessingStage) {
            ProcessingStage realStage = (ProcessingStage)replyStage;
            DtoProcessingStage resultStage = new DtoProcessingStage();
            resultStage.setId(realStage.getId());
            resultStage.setMessage(realStage.getMessage());
            resultStage.setWork(realStage.getWork());
            resultStage.setWorked(realStage.getWorked());
            resultStage.setPollDelay(realStage.getPollDelay());
            resultStage.setState(realStage.getState());
            return resultStage;
        }
        if (replyStage instanceof RequestInputStage) {
            RequestInputStage realStage = (RequestInputStage)replyStage;
            DtoRequestInputStage resultStage = new DtoRequestInputStage();
            resultStage.setId(realStage.getId());
            resultStage.setMessage(realStage.getMessage());
            resultStage.setTitle(realStage.getTitle());
            resultStage.setType(realStage.getType());
            return resultStage;
        }
        if (replyStage instanceof ResultStage) {
            ResultStage realStage = (ResultStage)replyStage;
            DtoResultStage resultStage = new DtoResultStage();
            resultStage.setId(realStage.getId());
            resultStage.setResult(realStage.getResult());
            return resultStage;
        }
        throw new IllegalStateException("unknown IReplyStage " + replyStage);
    }

    public static IUriProvider getCaptureProvider() {
        return CaptureProvider;
    }

    public static String getHttpRedirectTargetUri(IConversation conversation, HttpRedirectStage stage) {
        boolean requireCapture;
        UriBuilder builder = UriBuilder.fromUri((String)stage.getUrl());
        IntegrationOptions integrationOptions = ConversationServiceTools.getIntegrationOptions(conversation);
        if (stage.isAddConversationParameters()) {
            if (integrationOptions == null || !Boolean.TRUE.equals(integrationOptions.getAutoDispose())) {
                builder = builder.replaceQueryParam(PARAM_CONVERSATION, new Object[]{conversation.getHandle()}).replaceQueryParam(PARAM_STAGE, new Object[]{stage.getId()});
            }
            if (integrationOptions == null || StringTools.isEmpty((String)integrationOptions.getRedirectUri())) {
                if (ConversationServiceTools.isLegacyIntegrationSupport()) {
                    builder = builder.replaceQueryParam(PARAM_REDIRECT_URI, new Object[]{"?"});
                }
            } else {
                builder = builder.replaceQueryParam(PARAM_REDIRECT_URI, new Object[]{integrationOptions.getRedirectUriEncoded()});
            }
        }
        boolean bl = requireCapture = ConversationServiceTools.isLegacyIntegrationSupport() && ConversationServiceTools.getCaptureProvider() != null && !stage.isOutOfBand() && !stage.isAddConversationParameters() && (integrationOptions == null || StringTools.isEmpty((String)integrationOptions.getRedirectUriEncoded()));
        if (requireCapture) {
            builder = RequestContext.get().getUriBuilderContext();
            builder.path(ConversationServiceTools.getCaptureProvider().getUri().toString()).replaceQueryParam(PARAM_CONVERSATION, new Object[]{conversation.getHandle()}).replaceQueryParam(PARAM_REDIRECT_URI, new Object[]{"?"});
        }
        return builder.build(new Object[0]).toString();
    }

    public static IntegrationOptions getIntegrationOptions(IConversation<?> conversation) {
        return (IntegrationOptions)conversation.getAttribute(ATTR_INTEGRATION_OPTIONS);
    }

    public static Map<String, Object> getParameters(IConversation conversation) {
        return (Map)conversation.getAttribute(ATTR_PARAMETERS);
    }

    public static URI getRedirectUriExpanded(IConversation conversation) {
        IntegrationOptions integrationOptions = ConversationServiceTools.getIntegrationOptions(conversation);
        if (integrationOptions == null || StringTools.isEmpty((String)integrationOptions.getRedirectUri())) {
            return null;
        }
        URI uri = URI.create(integrationOptions.getRedirectUri());
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)uri);
        IConversation<?> rootConversation = ConversationServiceTools.getRootConversation(conversation);
        if (rootConversation != null) {
            LoadBalanceContext.get().processUri(uriBuilder);
            uriBuilder.replaceQueryParam(PARAM_CS_CONVERSATION, new Object[]{rootConversation.getHandle()});
            IReplyStage replyStage = rootConversation.getReplyStage();
            uriBuilder.replaceQueryParam(PARAM_CS_STAGE, new Object[]{replyStage.getId()});
            if (replyStage.isFinal() && Boolean.TRUE.equals(integrationOptions.getAutoDispose())) {
                String serialized;
                DtoReplyStage dtoStage = ConversationServiceTools.createDtoReplyStage(rootConversation, replyStage);
                dtoStage.setId(null);
                if (dtoStage instanceof DtoResultStage) {
                    ((DtoResultStage)dtoStage).setResult(null);
                }
                try {
                    serialized = MAPPER.writeValueAsString((Object)dtoStage);
                }
                catch (JsonProcessingException e) {
                    serialized = "{}";
                }
                String encoded = Base64.getUrlEncoder().encodeToString(serialized.getBytes(StandardCharsets.UTF_8));
                uriBuilder.replaceQueryParam(PARAM_CS_OUTCOME, new Object[]{encoded});
            }
        }
        return uriBuilder.build(new Object[0]);
    }

    public static IConversation<?> getRootConversation(IConversation<?> conversation) {
        return (IConversation)conversation.getAttribute(ATTR_ROOT_CONVERSATION);
    }

    public static boolean isLegacyIntegrationSupport() {
        return LegacyIntegrationSupport;
    }

    public static boolean isOobActive(IConversation<?> conversation) {
        return Boolean.TRUE.equals(conversation.getAttribute(ATTR_OOB_ACTIVE));
    }

    public static URI resume(IConversation conversation, Object value) {
        boolean oobReply = ConversationServiceTools.isOobActive(conversation);
        ConversationServiceTools.setOobActive(conversation, false);
        if (value != null) {
            conversation.acknowledge(null, value);
        }
        URI redirectUri = null;
        IConversation rootConversation = ConversationServiceTools.getRootConversation(conversation);
        if (rootConversation == null) {
            rootConversation = conversation;
        }
        if (!oobReply) {
            IReplyStage replyStage = rootConversation.getReplyStage();
            if (replyStage instanceof HttpRedirectStage) {
                HttpRedirectStage redirectStage = (HttpRedirectStage)replyStage;
                redirectUri = URI.create(ConversationServiceTools.getHttpRedirectTargetUri(rootConversation, redirectStage));
            } else {
                redirectUri = ConversationServiceTools.getRedirectUriExpanded(rootConversation);
            }
            IntegrationOptions integrationOptions = ConversationServiceTools.getIntegrationOptions(conversation);
            if (replyStage.isFinal() && integrationOptions != null && Boolean.TRUE.equals(integrationOptions.getAutoDispose())) {
                Log.debug("conversation {} autoDispose", (Object)conversation.getHandle());
                ConversationRegistry.get().unpublish(conversation);
            }
        }
        if (redirectUri == null) {
            redirectUri = RequestContext.get().getUriBuilderContext().path("api/v1/flow/conversation/close/").build(new Object[0]);
        }
        Log.debug("conversation {} redirect to {}", (Object)rootConversation.getHandle(), redirectUri);
        return redirectUri;
    }

    public static void setCaptureProvider(IUriProvider captureProvider) {
        CaptureProvider = captureProvider;
    }

    public static void setIntegrationOptions(IConversation<?> conversation, IntegrationOptions options) {
        conversation.setAttribute(ATTR_INTEGRATION_OPTIONS, (Object)options);
    }

    public static void setLegacyIntegrationSupport(boolean legacyIntegrationSupport) {
        LegacyIntegrationSupport = legacyIntegrationSupport;
    }

    public static void setOobActive(IConversation<?> conversation, boolean value) {
        conversation.setAttribute(ATTR_OOB_ACTIVE, (Object)value);
    }

    public static void setParameters(IConversation conversation, Map<String, Object> parameters) {
        conversation.setAttribute(ATTR_PARAMETERS, parameters);
    }

    public static void setRootConversation(IConversation<?> conversation) {
        conversation.setAttribute(ATTR_ROOT_CONVERSATION, conversation);
    }

    private ConversationServiceTools() {
    }
}

