/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.conversation.service.impl;

import de.intarsys.conversation.service.client.api.ConversationalResponse;
import de.intarsys.conversation.service.client.api.DtoConversationSnapshot;
import de.intarsys.conversation.service.client.api.DtoReplyStage;
import de.intarsys.conversation.service.client.api.IntegrationOptions;
import de.intarsys.conversation.service.client.api.RequestAcknowledge;
import de.intarsys.conversation.service.client.api.RequestCancel;
import de.intarsys.conversation.service.client.api.ResponseAcknowledge;
import de.intarsys.conversation.service.client.api.ResponseCancel;
import de.intarsys.conversation.service.component.api.Outcome;
import de.intarsys.conversation.service.component.api.RequestGetParameters;
import de.intarsys.conversation.service.component.api.RequestResume;
import de.intarsys.conversation.service.component.api.ResponseGetParameters;
import de.intarsys.conversation.service.component.api.ResponseResume;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.conversation.ConversationExpired;
import de.intarsys.tools.conversation.Conversational;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IConversationRegistry;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.impl.HttpRedirectStage;
import de.intarsys.tools.conversation.service.impl.ConversationServiceTools;
import de.intarsys.tools.conversation.service.impl.PACKAGE;
import de.intarsys.tools.exception.InvalidRequestException;
import de.intarsys.tools.jaxrs.ServiceImplementor;
import de.intarsys.tools.jaxrs.Stateful;
import de.intarsys.tools.loadbalance.LoadBalanced;
import de.intarsys.tools.string.StringTools;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.glassfish.jersey.server.CloseableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring6.SpringTemplateEngine;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.UrlTemplateResolver;

@Path(value="/v1/flow/conversation")
@ServiceImplementor
public class SvcConversation {
    private static final Logger Log = LoggerFactory.getLogger(SvcConversation.class);
    public static final String PATH_CONVERSATION_RESUME = "api/v1/flow/conversation/resume/";
    public static final String PATH_CONVERSATION_CLOSE = "api/v1/flow/conversation/close/";
    private static final Attribute RESULT_REPLIED = new Attribute("resultReplied");
    @jakarta.ws.rs.core.Context
    private CloseableService closableService;
    @Autowired
    private IConversationRegistry conversationRegistry;
    private SpringTemplateEngine templateEngine = new SpringTemplateEngine();

    public SvcConversation() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasename(PACKAGE.Messages.getName());
        this.templateEngine.setMessageSource((MessageSource)messageSource);
        this.templateEngine.setTemplateResolver((ITemplateResolver)new UrlTemplateResolver());
    }

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/acknowledge")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation
    public ResponseAcknowledge acknowledge(RequestAcknowledge request) {
        this.requireNonNull(request, "Empty request body");
        IConversation<?> conversation = this.lookupConversationByHandle(request.getConversationHandle());
        conversation.acknowledge(request.getInReplyTo(), request.getValue());
        ResponseAcknowledge response = new ResponseAcknowledge();
        this.finishRequest((ConversationalResponse)response, conversation);
        return response;
    }

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/cancel")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation
    public ResponseCancel cancel(RequestCancel request) {
        this.requireNonNull(request, "Empty request body");
        IConversation<?> conversation = this.lookupConversationByHandle(request.getConversationHandle());
        conversation.cancel(false);
        return new ResponseCancel();
    }

    @Conversational(conversationArgIndex=1)
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @GET
    @Path(value="/capture")
    @Operation(hidden=true, operationId="conversationCapture")
    public Response capture(@QueryParam(value="callback") String callback, @QueryParam(value="conversation") String conversationId) {
        this.requireNonEmpty(conversationId, "Query parameter 'conversation' is missing or empty");
        IConversation<?> conversation = this.lookupConversationByHandle(conversationId);
        IReplyStage replyStage = conversation.getReplyStage();
        if (!(replyStage instanceof HttpRedirectStage)) {
            throw new InvalidRequestException("HttpRedirectStage required for 'capture'");
        }
        HttpRedirectStage redirectStage = (HttpRedirectStage)replyStage;
        String url = redirectStage.getUrl();
        IntegrationOptions integrationOptions = new IntegrationOptions();
        integrationOptions.setRedirectUri(callback);
        ConversationServiceTools.setRootConversation(conversation);
        ConversationServiceTools.setIntegrationOptions(conversation, integrationOptions);
        return Response.status((Response.Status)Response.Status.FOUND).location(URI.create(url)).build();
    }

    @GET
    @Path(value="/close")
    @Produces(value={"text/html"})
    @Operation(hidden=true, operationId="conversationClose")
    public Response close() {
        return this.handleClose(null);
    }

    protected void finishRequest(ConversationalResponse response, IConversation<?> conversation) {
        IReplyStage replyStage = conversation.getReplyStage();
        if (replyStage.isFinal()) {
            Object resultReplied = conversation.setAttribute((Object)RESULT_REPLIED, (Object)true);
            if (resultReplied != null) {
                throw new ConversationExpired("unknown conversation '" + conversation.getHandle() + "'");
            }
            this.getClosableService().add(() -> this.conversationRegistry.unpublish(conversation));
        }
        DtoReplyStage publishedStage = ConversationServiceTools.createDtoReplyStage(conversation, replyStage);
        DtoConversationSnapshot publishedSnapshot = ConversationServiceTools.createDtoConversationSnapshot(conversation, publishedStage);
        response.setSnapshot(publishedSnapshot);
        Log.info("reply stage {}", (Object)replyStage);
    }

    protected CloseableService getClosableService() {
        return this.closableService;
    }

    protected IConversationRegistry getConversationRegistry() {
        return this.conversationRegistry;
    }

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/getParameters")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(hidden=true, operationId="conversationParameters")
    public ResponseGetParameters getParameters(RequestGetParameters request) {
        this.requireNonNull(request, "Empty request body");
        IConversation<?> conversation = this.lookupConversationByHandle(request.getConversationHandle());
        return new ResponseGetParameters(ConversationServiceTools.getParameters(conversation));
    }

    protected Response handleClose(IConversation<?> conversation) {
        Log.debug("handle close");
        URL resource = this.getClass().getResource("close.html");
        Context context = new Context();
        String entity = this.templateEngine.process(resource.toExternalForm(), (IContext)context);
        return Response.ok((Object)entity, (MediaType)MediaType.TEXT_HTML_TYPE).build();
    }

    protected IConversation<?> lookupConversationByAttributes(String attributes) {
        String decoded = new String(Base64.getDecoder().decode(attributes), StandardCharsets.UTF_8);
        IConversation conversation = this.getConversationRegistry().lookupByAttributes(decoded);
        if (conversation == null) {
            throw new ConversationExpired("no conversation found for '" + attributes + "'");
        }
        return conversation;
    }

    protected IConversation<?> lookupConversationByHandle(String handle) {
        IConversation conversation = this.getConversationRegistry().getConversation(handle);
        if (conversation == null) {
            throw new ConversationExpired("unknown or expired conversation");
        }
        return conversation;
    }

    @Conversational(conversationArgIndex=0)
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @GET
    @Path(value="/resume")
    @Operation(hidden=true, operationId="conversationResume")
    public Response resumeGet(@QueryParam(value="state") String handle, @QueryParam(value="attributes") String attributes, @QueryParam(value="outcome") String outcomeToken) {
        IConversation<?> conversation;
        if (!StringTools.isEmpty((String)handle)) {
            conversation = this.lookupConversationByHandle(handle);
        } else if (!StringTools.isEmpty((String)attributes)) {
            conversation = this.lookupConversationByAttributes(attributes);
        } else {
            throw new IllegalArgumentException("'state' or 'attributes' required to resume conversation");
        }
        Outcome outcome = Outcome.create((Object)outcomeToken);
        Log.debug("handle resume conversation {}, outcome {}", (Object)conversation.getHandle(), (Object)outcome);
        URI redirectUri = ConversationServiceTools.resume(conversation, outcome);
        return Response.status((Response.Status)Response.Status.FOUND).location(redirectUri).build();
    }

    @Conversational
    @LoadBalanced
    @Stateful(role=Stateful.Role.Consumer)
    @POST
    @Path(value="/resume")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(hidden=true, operationId="conversationResume")
    public ResponseResume resumePost(RequestResume request) {
        this.requireNonNull(request, "Empty request body");
        String handle = request.getConversationHandle();
        IConversation<?> conversation = this.lookupConversationByHandle(handle);
        Object value = request.getValue();
        if (request.isCancel()) {
            conversation.cancel(false);
            value = null;
        }
        URI redirectUri = ConversationServiceTools.resume(conversation, value);
        return new ResponseResume(redirectUri.toString());
    }

    public void setConversationRegistry(IConversationRegistry conversationRegistry) {
        this.conversationRegistry = conversationRegistry;
    }

    private void requireNonNull(Object value, String message) {
        if (value == null) {
            throw new IllegalArgumentException(message);
        }
    }

    private void requireNonEmpty(String value, String message) {
        if (StringTools.isEmpty((String)value)) {
            throw new IllegalArgumentException(message);
        }
    }
}

