/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.adapter.awt;

import de.intarsys.cwt.awt.environment.CwtAwtGraphicsContext;
import de.intarsys.cwt.awt.environment.CwtAwtGraphicsEnvironment;
import de.intarsys.cwt.awt.image.IAwtImage;
import de.intarsys.cwt.common.BlendMode;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.image.ImageConvertOption;
import de.intarsys.pdf.pd.PDAxialShading;
import de.intarsys.pdf.pd.PDFunction;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.adapter.CommonGraphicsEnvironmentAdapter;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpace;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;
import de.intarsys.pdf.platform.cwt.image.PlatformImageFactory;
import de.intarsys.pdf.platform.cwt.paint.ColorPaint;
import de.intarsys.pdf.platform.cwt.paint.PatternPaint;
import de.intarsys.pdf.platform.cwt.paint.ShadingPaint;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.image.BufferedImage;

public class AwtGraphicsEnvironmentAdapter
extends CommonGraphicsEnvironmentAdapter {
    protected float adjustAlpha(float[] rgb, float alpha) {
        float alphaFactor = 0.5f;
        if (rgb != null) {
            float luminance = (rgb[0] + rgb[1] + rgb[2]) / 3.0f;
            alphaFactor = 1.0f - luminance;
        }
        return alpha * alphaFactor;
    }

    @Deprecated
    public synchronized BufferedImage createImage(PDImage pdImage) {
        return ((IAwtImage)PlatformImageFactory.get().createPlatformImage(pdImage).asImage(IAwtImage.class, new ImageConvertOption[0])).getBufferedImage();
    }

    protected Paint createPaintColorPaint(ColorPaint paint, boolean adjust) {
        AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(paint.getPdColorSpace());
        float[] colorValues = paint.getColorValues();
        float[] rgb = colorValues == null ? new float[]{0.0f, 0.0f, 0.0f} : awtColorSpace.getRGB(colorValues);
        float alpha = paint.getAlphaValue();
        if (adjust) {
            alpha = this.adjustAlpha(rgb, alpha);
        }
        return new Color(rgb[0], rgb[1], rgb[2], alpha);
    }

    protected Paint createPaintPatternPaint(PatternPaint paint) {
        return new Color(0.5f, 0.5f, 0.5f, 0.5f);
    }

    protected Paint createPaintShadingPaint(ShadingPaint paint) {
        if (!(paint.getPdShading() instanceof PDAxialShading)) {
            return new Color(0.5f, 0.5f, 0.5f, 0.5f);
        }
        PDAxialShading axialShading = (PDAxialShading)paint.getPdShading();
        float[] coords = axialShading.getCoords();
        float[] domain = axialShading.getDomain();
        PDFunction function = axialShading.getFunction();
        AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(paint.getPdShading().getColorSpace());
        float[] rgb = awtColorSpace.getRGB(function.evaluate(new float[]{domain[0]}));
        Color rgbColor1 = new Color(rgb[0], rgb[1], rgb[2]);
        rgb = awtColorSpace.getRGB(function.evaluate(new float[]{domain[1]}));
        Color rgbColor2 = new Color(rgb[0], rgb[1], rgb[2]);
        return new GradientPaint(coords[0], coords[1], rgbColor1, coords[2], coords[3], rgbColor2);
    }

    @Deprecated
    public void drawImage(IGraphicsContext graphicsContext, PDImage pdImage, float x, float y) {
        graphicsContext.drawImage((IImage)PlatformImageFactory.get().createPlatformImage(pdImage), x, y);
    }

    public IGraphicsEnvironment getGraphicsEnvironment() {
        return CwtAwtGraphicsEnvironment.get();
    }

    public void setBackgroundColorPaint(IGraphicsContext graphicsContext, ColorPaint paint) {
        CwtAwtGraphicsContext awtGC = (CwtAwtGraphicsContext)graphicsContext;
        Paint awtPaint = this.createPaintColorPaint(paint, awtGC.getBlendMode() == BlendMode.MULTIPLY);
        awtGC.setBackgroundPaint(awtPaint);
    }

    public void setBackgroundPatternPaint(IGraphicsContext graphicsContext, PatternPaint paint) {
        CwtAwtGraphicsContext awtGC = (CwtAwtGraphicsContext)graphicsContext;
        Paint awtPaint = this.createPaintPatternPaint(paint);
        awtGC.setBackgroundPaint(awtPaint);
    }

    public void setBackgroundShadingPaint(IGraphicsContext graphicsContext, ShadingPaint paint) {
        CwtAwtGraphicsContext awtGC = (CwtAwtGraphicsContext)graphicsContext;
        Paint awtPaint = this.createPaintShadingPaint(paint);
        awtGC.setBackgroundPaint(awtPaint);
    }

    public void setForegroundColorPaint(IGraphicsContext graphicsContext, ColorPaint paint) {
        CwtAwtGraphicsContext awtGC = (CwtAwtGraphicsContext)graphicsContext;
        Paint awtPaint = this.createPaintColorPaint(paint, awtGC.getBlendMode() == BlendMode.MULTIPLY);
        awtGC.setForegroundPaint(awtPaint);
    }

    public void setForegroundPatternPaint(IGraphicsContext graphicsContext, PatternPaint paint) {
        CwtAwtGraphicsContext awtGC = (CwtAwtGraphicsContext)graphicsContext;
        Paint awtPaint = this.createPaintPatternPaint(paint);
        awtGC.setForegroundPaint(awtPaint);
    }

    public void setForegroundShadingPaint(IGraphicsContext graphicsContext, ShadingPaint paint) {
        CwtAwtGraphicsContext awtGC = (CwtAwtGraphicsContext)graphicsContext;
        Paint awtPaint = this.createPaintShadingPaint(paint);
        awtGC.setForegroundPaint(awtPaint);
    }
}

