/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.cwt.awt.image.CwtAwtImageTools;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtCSDevice;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class AwtCSDeviceGray
extends AwtCSDevice {
    public AwtCSDeviceGray(PDColorSpace pdColorSpace) {
        super(pdColorSpace);
    }

    @Override
    protected ColorSpace createColorSpace() {
        return ColorSpace.getInstance(1003);
    }

    @Override
    public ColorModel getColorModel(PDImage pdImage) {
        int bits = pdImage.getBitsPerComponent();
        if (bits < 8) {
            byte[] values = new byte[(int)Math.pow(2.0, bits)];
            for (int index = 0; index < values.length; ++index) {
                int value = (int)((float)index * 255.0f / (float)(values.length - 1));
                values[index] = (byte)(value & 0xFF);
            }
            IndexColorModel colormodel = new IndexColorModel(bits, values.length, values, values, values);
            return colormodel;
        }
        return CwtAwtImageTools.getGrayColorModel();
    }

    @Override
    public int getNumComponents() {
        return 1;
    }

    @Override
    public float[] getRGB(float[] values) {
        return new float[]{values[0], values[0], values[0]};
    }

    protected PDCSDeviceGray myPDColorSpace() {
        return (PDCSDeviceGray)this.getPDColorSpace();
    }
}

