/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.cwt.awt.image.CwtAwtImageTools;
import de.intarsys.pdf.pd.PDCSICCBased;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtCSCIEBased;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.color.ProfileDataException;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class AwtCSICCBased
extends AwtCSCIEBased {
    public AwtCSICCBased(PDColorSpace pdColorSpace) {
        super(pdColorSpace);
    }

    @Override
    protected ColorSpace createColorSpace() {
        PDColorSpace alternate;
        ICC_Profile profile = this.resolveProfile();
        if (profile != null) {
            try {
                ICC_ColorSpace colorSpace = new ICC_ColorSpace(profile);
                float[] testValues = new float[colorSpace.getNumComponents()];
                for (int index = 0; index < testValues.length; ++index) {
                    testValues[index] = ((ColorSpace)colorSpace).getMinValue(index);
                }
                ((ColorSpace)colorSpace).toRGB(testValues);
                return colorSpace;
            }
            catch (ProfileDataException profileDataException) {
                // empty catch block
            }
        }
        if ((alternate = this.myPDColorSpace().getAlternate()) != null) {
            return AwtCSICCBased.getColorSpace(alternate).getColorSpace();
        }
        return FALLBACK;
    }

    @Override
    public ColorModel getColorModel(PDImage pdImage) {
        int bits = pdImage.getBitsPerComponent();
        ColorSpace colorSpace = this.getColorSpace();
        if (bits < 8 && colorSpace.getNumComponents() == 1) {
            byte[] r = new byte[(int)Math.pow(2.0, bits)];
            byte[] g = new byte[r.length];
            byte[] b = new byte[r.length];
            for (int index = 0; index < r.length; ++index) {
                float[] values = colorSpace.toRGB(new float[]{(float)index / (float)(r.length - 1)});
                r[index] = (byte)((int)(values[0] * 255.0f) & 0xFF);
                g[index] = (byte)((int)(values[1] * 255.0f) & 0xFF);
                b[index] = (byte)((int)(values[2] * 255.0f) & 0xFF);
            }
            IndexColorModel colormodel = new IndexColorModel(bits, r.length, r, g, b);
            return colormodel;
        }
        return CwtAwtImageTools.createColorModel((ColorSpace)colorSpace);
    }

    protected PDCSICCBased myPDColorSpace() {
        return (PDCSICCBased)this.getPDColorSpace();
    }

    public ICC_Profile resolveProfile() {
        try {
            return ICC_Profile.getInstance(this.myPDColorSpace().cosGetProfileStream().getDecodedBytes());
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

