/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image.awt;

import de.intarsys.cwt.image.ImageException;
import de.intarsys.cwt.image.ImageTools;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDCSCalGray;
import de.intarsys.pdf.pd.PDCSCalRGB;
import de.intarsys.pdf.pd.PDCSDeviceGray;
import de.intarsys.pdf.pd.PDCSDeviceRGB;
import de.intarsys.pdf.pd.PDCSICCBased;
import de.intarsys.pdf.pd.PDCSIndexed;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpace;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;

public class PlatformImageTools {
    public static ColorModel createColorModel(PDImage pdImage) {
        if (pdImage.isImageMask()) {
            return new IndexColorModel(1, 2, new int[]{0, -1}, 0, false, -1, 0);
        }
        AwtColorSpace colorSpace = AwtColorSpaceFactory.get().createColorSpace(pdImage.getColorSpace());
        return colorSpace.getColorModel(pdImage);
    }

    public static boolean matchColorSpace(PDImage pdImage, String colorSpaceType) {
        PDColorSpace colorSpace = pdImage.getColorSpace();
        if ("GRAY".equals(colorSpaceType) && (colorSpace == PDCSDeviceGray.SINGLETON || colorSpace instanceof PDCSCalGray || colorSpace instanceof PDCSIndexed || colorSpace instanceof PDCSICCBased && colorSpace.getNumComponents() == 1)) {
            return true;
        }
        return ("RGB".equals(colorSpaceType) || "YCbCr".equals(colorSpaceType)) && (pdImage.getColorSpace() == PDCSDeviceRGB.SINGLETON || colorSpace instanceof PDCSCalRGB || colorSpace instanceof PDCSICCBased && colorSpace.getNumComponents() == 3);
    }

    @Deprecated
    public static boolean matchColorSpaceType(PDImage pdImage, InputStream stream) throws IOException {
        String colorSpaceType;
        if (pdImage.cosGetStream().hasFilter(Filter.CN_Filter_JPXDecode)) {
            return true;
        }
        try {
            colorSpaceType = ImageTools.extractJPEGColorSpaceType((InputStream)stream);
        }
        catch (ImageException ex) {
            colorSpaceType = "YCbCr";
        }
        return PlatformImageTools.matchColorSpace(pdImage, colorSpaceType);
    }
}

