/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image.iio2pdf;

import de.intarsys.cwt.awt.image.CwtAwtImage;
import de.intarsys.cwt.awt.image.ImageIOImageEntry;
import de.intarsys.cwt.image.CommonImageConverter;
import de.intarsys.cwt.image.IImage;
import de.intarsys.cwt.image.ImageConvertOption;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.image.CwtPlatformImage;
import de.intarsys.pdf.platform.cwt.image.IPlatformImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Set;

public class ImageConverter
extends CommonImageConverter<ImageIOImageEntry, IPlatformImage> {
    private static Collection<String> SUPPORTED_COMPRESSION_TYPE_NAMES = Set.of("JPEG");

    public ImageConverter() {
        super(ImageIOImageEntry.class, IPlatformImage.class);
    }

    public boolean acceptSourceImage(IImage sourceImage) {
        return this.acceptSourceType(sourceImage.getClass()) && SUPPORTED_COMPRESSION_TYPE_NAMES.contains(((ImageIOImageEntry)sourceImage).getCompressionTypeName());
    }

    public IPlatformImage convertImage(ImageIOImageEntry sourceImage, ImageConvertOption ... options) {
        if ("JPEG".equals(sourceImage.getCompressionTypeName())) {
            return this.convertJpeg(sourceImage);
        }
        throw new IllegalArgumentException("can't handle source image");
    }

    protected IPlatformImage convertJpeg(ImageIOImageEntry sourceImage) {
        byte[] bytes;
        PDImage pdImage = (PDImage)PDImage.META.createNew();
        pdImage.setWidth(sourceImage.getWidth());
        pdImage.setHeight(sourceImage.getHeight());
        pdImage.setBitsPerComponent(8);
        if ("YCbCr".equals(sourceImage.getColorSpaceType())) {
            pdImage.cosSetColorSpace(PDColorSpace.CN_CS_DeviceRGB);
        } else if ("GRAY".equals(sourceImage.getColorSpaceType())) {
            pdImage.cosSetColorSpace(PDColorSpace.CN_CS_DeviceGray);
        } else if ("YCCK".equals(sourceImage.getColorSpaceType())) {
            pdImage.cosSetColorSpace(PDColorSpace.CN_CS_DeviceCMYK);
            pdImage.setDecode(new int[]{1, 0, 1, 0, 1, 0, 1, 0});
        }
        COSStream stream = pdImage.cosGetStream();
        stream.addFilter(Filter.CN_Filter_DCTDecode);
        try (InputStream inputStream = sourceImage.getContainer().getLocator().getInputStream();){
            bytes = inputStream.readAllBytes();
        }
        catch (IOException ex) {
            return (IPlatformImage)CwtAwtImage.createErrorImage((Throwable)ex).asImage(IPlatformImage.class, new ImageConvertOption[0]);
        }
        stream.setEncodedBytes(bytes);
        return new CwtPlatformImage(pdImage);
    }
}

