/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image.pdf2awt;

import de.intarsys.cwt.image.ImageException;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.image.awt.PlatformImageTools;
import de.intarsys.pdf.platform.cwt.image.pdf2awt.IImageConverter;
import de.intarsys.pdf.platform.cwt.image.pdf2awt.IRasterConverter;
import de.intarsys.pdf.platform.cwt.image.pdf2awt.RC8BPC;
import de.intarsys.pdf.platform.cwt.image.pdf2awt.RCNon8BPC;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.List;

public class DirectConverter
implements IImageConverter {
    private static List<IRasterConverter> RasterConverters = new ArrayList<IRasterConverter>();

    @Override
    public boolean accept(PDImage pdImage) {
        return true;
    }

    @Override
    public BufferedImage createBufferedImage(PDImage pdImage) {
        int width = pdImage.getWidth();
        int height = pdImage.getHeight();
        int bitsPerComponent = pdImage.getBitsPerComponent();
        byte[] bytes = pdImage.getAdjustedBytes();
        DataBufferByte dataBuffer = new DataBufferByte(bytes, bytes.length);
        WritableRaster raster = null;
        int numComponents = pdImage.getColorSpace().getNumComponents();
        for (IRasterConverter rasterConverter : RasterConverters) {
            if (!rasterConverter.accept(bitsPerComponent)) continue;
            raster = rasterConverter.createWritableRaster(dataBuffer, width, height, bitsPerComponent, numComponents);
            break;
        }
        if (raster == null) {
            throw new ImageException("cannot convert image: unsupported component depth " + bitsPerComponent);
        }
        ColorModel colorModel = PlatformImageTools.createColorModel(pdImage);
        return new BufferedImage(colorModel, raster, false, null);
    }

    static {
        RasterConverters.add(new RC8BPC());
        RasterConverters.add(new RCNon8BPC());
    }
}

