/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image.pdf2awt;

import de.intarsys.cwt.awt.image.CwtAwtImage;
import de.intarsys.cwt.awt.image.IAwtImage;
import de.intarsys.cwt.image.CommonImageConverter;
import de.intarsys.cwt.image.ImageConvertOption;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.image.IPlatformImage;
import de.intarsys.pdf.platform.cwt.image.PlatformImageFactory;
import de.intarsys.pdf.platform.cwt.image.pdf2awt.DirectConverter;
import de.intarsys.pdf.platform.cwt.image.pdf2awt.IImageConverter;
import de.intarsys.pdf.platform.cwt.image.pdf2awt.JpegConverter;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.JAI;
import javax.media.jai.operator.FormatDescriptor;
import javax.media.jai.operator.ScaleDescriptor;

public class ImageConverter
extends CommonImageConverter<IPlatformImage, IAwtImage> {
    private static IImageConverter DirectConverter = new DirectConverter();
    private static IImageConverter JpegConverter = new JpegConverter();
    private static final float MAX_SCALE = 400000.0f;

    public ImageConverter() {
        super(IPlatformImage.class, IAwtImage.class);
    }

    protected BufferedImage applyMask(BufferedImage baseBufferedImage, PDImage maskPdImage) {
        float ratio;
        int baseWidth = baseBufferedImage.getWidth();
        int baseHeight = baseBufferedImage.getHeight();
        RenderedImage baseImage = baseBufferedImage;
        ColorModel baseColorModel = baseBufferedImage.getColorModel();
        if (!(baseColorModel instanceof ComponentColorModel)) {
            baseImage = this.createComponentFormatDescriptor(baseImage, baseColorModel.getColorSpace());
        }
        int maskWidth = maskPdImage.getWidth();
        int maskHeight = maskPdImage.getHeight();
        BufferedImage maskImage = this.convertBaseImage(maskPdImage);
        float baseScaleX = 1.0f;
        float baseScaleY = 1.0f;
        float maskScaleX = 1.0f;
        float maskScaleY = 1.0f;
        if (baseWidth >= maskWidth) {
            maskScaleX = (float)baseWidth / (float)maskWidth;
        } else {
            baseScaleX = (float)maskWidth / (float)baseWidth;
        }
        if (baseHeight >= maskHeight) {
            maskScaleY = (float)baseHeight / (float)maskHeight;
        } else {
            baseScaleY = (float)maskHeight / (float)baseHeight;
        }
        if (baseScaleX * baseScaleY > 400000.0f) {
            ratio = 400000.0f / (baseScaleX * baseScaleY);
            baseScaleX *= ratio;
            baseScaleY *= ratio;
            maskScaleX *= ratio;
            maskScaleY *= ratio;
        }
        if (maskScaleX * maskScaleY > 400000.0f) {
            ratio = 400000.0f / (maskScaleX * maskScaleY);
            baseScaleX *= ratio;
            baseScaleY *= ratio;
            maskScaleX *= ratio;
            maskScaleY *= ratio;
        }
        if (baseScaleX != 1.0f || baseScaleY != 1.0f) {
            baseImage = ScaleDescriptor.create((RenderedImage)baseImage, (Float)Float.valueOf(baseScaleX), (Float)Float.valueOf(baseScaleY), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)Interpolation.getInstance((int)0), null);
        }
        if (maskScaleX != 1.0f || maskScaleY != 1.0f) {
            maskImage = ScaleDescriptor.create((RenderedImage)maskImage, (Float)Float.valueOf(maskScaleX), (Float)Float.valueOf(maskScaleY), (Float)Float.valueOf(0.0f), (Float)Float.valueOf(0.0f), (Interpolation)Interpolation.getInstance((int)0), null);
        }
        ComponentColorModel targetColorModel = new ComponentColorModel(baseColorModel.getColorSpace(), true, false, 3, baseColorModel.getTransferType());
        WritableRaster targetRaster = ((ColorModel)targetColorModel).createCompatibleWritableRaster(baseImage.getWidth(), baseImage.getHeight());
        byte[] baseBytes = ((DataBufferByte)baseImage.getData().getDataBuffer()).getData();
        byte[] maskBytes = ((DataBufferByte)maskImage.getData().getDataBuffer()).getData();
        byte[] targetBytes = ((DataBufferByte)targetRaster.getDataBuffer()).getData();
        int numColorComponents = baseColorModel.getNumColorComponents();
        for (int pixelIndex = 0; pixelIndex < maskBytes.length; ++pixelIndex) {
            for (int componentIndex = 0; componentIndex < numColorComponents; ++componentIndex) {
                targetBytes[pixelIndex * (numColorComponents + 1) + componentIndex] = baseBytes[pixelIndex * numColorComponents + componentIndex];
            }
            targetBytes[pixelIndex * (numColorComponents + 1) + numColorComponents] = maskBytes[pixelIndex];
        }
        return new BufferedImage(targetColorModel, targetRaster, false, null);
    }

    public BufferedImage convertBaseImage(PDImage pdImage) {
        if (JpegConverter.accept(pdImage)) {
            return JpegConverter.createBufferedImage(pdImage);
        }
        return DirectConverter.createBufferedImage(pdImage);
    }

    public IAwtImage convertImage(IPlatformImage sourceImage, ImageConvertOption ... options) {
        PDImage pdImage = sourceImage.getPDImage();
        return new CwtAwtImage(this.convertImage(pdImage), pdImage.getWidth(), pdImage.getHeight());
    }

    public BufferedImage convertImage(PDImage pdImage) {
        IPlatformImage maskPlatformImage;
        BufferedImage bufferedImage = this.convertBaseImage(pdImage);
        if (pdImage.getBitsPerComponent() == 8) {
            DataBufferByte dataBuffer = (DataBufferByte)bufferedImage.getRaster().getDataBuffer();
            maskPlatformImage = PlatformImageFactory.get().createPlatformMaskImage(pdImage, dataBuffer.getData());
        } else {
            maskPlatformImage = PlatformImageFactory.get().createPlatformMaskImage(pdImage);
        }
        if (maskPlatformImage != null) {
            bufferedImage = this.applyMask(bufferedImage, maskPlatformImage.getPDImage());
        }
        return bufferedImage;
    }

    protected RenderedImage createComponentFormatDescriptor(RenderedImage sourceImage, ColorSpace colorSpace) {
        int width = sourceImage.getWidth();
        int height = sourceImage.getHeight();
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, false, false, 1, 0);
        return FormatDescriptor.create((RenderedImage)sourceImage, (Integer)0, (RenderingHints)this.createJAIRenderingHints(width, height, colorModel));
    }

    protected RenderingHints createJAIRenderingHints(int width, int height, ColorModel colorModel) {
        SampleModel sampleModel = colorModel.createCompatibleSampleModel(width, height);
        ImageLayout imageLayout = new ImageLayout(0, 0, width, height, sampleModel, colorModel);
        return new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout);
    }
}

