/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image.pdf2awt;

import de.intarsys.cwt.image.ImageException;
import de.intarsys.cwt.image.ImageTools;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDCSDeviceCMYK;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.image.awt.PlatformImageTools;
import de.intarsys.pdf.platform.cwt.image.pdf2awt.IImageConverter;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class JpegConverter
implements IImageConverter {
    @Override
    public boolean accept(PDImage pdImage) {
        COSStream imgStream = pdImage.cosGetStream();
        return imgStream.hasFilter(Filter.CN_Filter_DCTDecode) || imgStream.hasFilter(Filter.CN_Filter_DCT) || imgStream.hasFilter(Filter.CN_Filter_JPXDecode);
    }

    protected void convertYCCK(WritableRaster raster) {
        DataBufferByte dataBuffer = (DataBufferByte)raster.getDataBuffer();
        byte[] bytes = dataBuffer.getData();
        int pixelCount = bytes.length / 4;
        for (int index = 0; index < pixelCount; ++index) {
            int pixelBase = index * 4;
            double y = 0xFF & bytes[pixelBase];
            double cb = (0xFF & bytes[pixelBase + 1]) - 128;
            double cr = (0xFF & bytes[pixelBase + 2]) - 128;
            double cyan = 255.0 - (y + 1.402 * cr);
            double magenta = 255.0 - (y - 0.34414 * cb - 0.71414 * cr);
            double yellow = 255.0 - (y + 1.772 * cb);
            if (cyan < 0.0) {
                cyan = 0.0;
            }
            if (cyan > 255.0) {
                cyan = 255.0;
            }
            if (magenta < 0.0) {
                magenta = 0.0;
            }
            if (magenta > 255.0) {
                magenta = 255.0;
            }
            if (yellow < 0.0) {
                yellow = 0.0;
            }
            if (yellow > 255.0) {
                yellow = 255.0;
            }
            bytes[pixelBase] = (byte)cyan;
            bytes[pixelBase + 1] = (byte)magenta;
            bytes[pixelBase + 2] = (byte)yellow;
        }
    }

    @Override
    public BufferedImage createBufferedImage(PDImage pdImage) {
        try {
            String colorSpaceType;
            COSStream jpegStream = pdImage.cosExtractJPEGStream();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(jpegStream.getEncodedBytes());
            try {
                colorSpaceType = ImageTools.extractJPEGColorSpaceType((InputStream)inputStream);
            }
            catch (ImageException ex) {
                colorSpaceType = "YCbCr";
            }
            WritableRaster raster = null;
            if ("GRAY".equals(colorSpaceType) || "RGB".equals(colorSpaceType) || "YCbCr".equals(colorSpaceType)) {
                try {
                    ((InputStream)inputStream).reset();
                    BufferedImage bufferedImage = ImageIO.read(inputStream);
                    if (PlatformImageTools.matchColorSpace(pdImage, colorSpaceType)) {
                        return bufferedImage;
                    }
                    raster = bufferedImage.getRaster();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (raster == null) {
                ((InputStream)inputStream).reset();
                raster = this.createWritableRaster(inputStream);
            }
            if ("YCCK".equals(colorSpaceType) && pdImage.getColorSpace() == PDCSDeviceCMYK.SINGLETON) {
                this.convertYCCK(raster);
            }
            return new BufferedImage(PlatformImageTools.createColorModel(pdImage), raster, false, null);
        }
        catch (IOException ex) {
            throw new ImageException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected WritableRaster createWritableRaster(InputStream inputStream) throws IOException {
        try (ImageInputStream imageStream = ImageIO.createImageInputStream(inputStream);){
            Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(imageStream);
            while (imageReaders.hasNext()) {
                ImageReader imageReader = imageReaders.next();
                try {
                    imageReader.setInput(imageStream);
                    WritableRaster writableRaster = (WritableRaster)imageReader.readRaster(0, null);
                    imageReader.dispose();
                    return writableRaster;
                }
                catch (IOException iOException) {
                    block9: {
                        break block9;
                        catch (Throwable throwable) {
                            imageReader.dispose();
                            throw throwable;
                        }
                    }
                    imageReader.dispose();
                    imageStream.reset();
                }
            }
            throw new ImageException("cannot convert image");
        }
    }
}

