/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.common.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportItem;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportFolderLocatorPathDeserializer;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportItemLocatorHandleDeserializer;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportItemLocatorHandleSerializer;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportItemLocatorPathSerializer;
import de.intarsys.tools.jaxrs.ServiceParam;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.List;

@ServiceParam
public class TransportFolder
extends TransportItem {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<TransportItem> items = new ArrayList<TransportItem>();
    @JsonSerialize(using=TransportItemLocatorPathSerializer.class)
    @JsonDeserialize(using=TransportFolderLocatorPathDeserializer.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ILocator path;
    @JsonSerialize(using=TransportItemLocatorHandleSerializer.class)
    @JsonDeserialize(using=TransportItemLocatorHandleDeserializer.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ILocator handle;
    @JsonIgnore
    private ILocator locator;

    public static TransportFolderBuilder builder() {
        return new TransportFolderBuilder();
    }

    public TransportFolder() {
    }

    public TransportFolder(String name) {
        super(name);
    }

    public void addItem(TransportItem item) {
        if (item.isLink()) {
            throw new IllegalArgumentException("folder cannot contain a link");
        }
        this.items.add(item);
        item.setParent(this);
    }

    public ILocator getHandle() {
        return this.handle;
    }

    public List<TransportItem> getItems() {
        return this.items;
    }

    @Override
    public ILocator getLocator() {
        return this.locator;
    }

    public ILocator getPath() {
        return this.path;
    }

    @Override
    public String getType() {
        return "f";
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public boolean isLink() {
        return this.handle != null;
    }

    @Override
    public void setContent(ILocator locator) {
    }

    @Override
    public void setHandle(ILocator locator) {
        this.handle = locator;
        this.setLocator(locator);
    }

    protected void setLocator(ILocator locator) {
        if (StringTools.isEmpty((String)this.basicGetName()) && locator != null) {
            this.setName(locator.getName());
        }
        this.locator = locator;
    }

    @Override
    public void setPath(ILocator locator) {
        this.path = locator;
        this.setLocator(locator);
    }

    public static class TransportFolderBuilder
    extends TransportItem.TransportItemBuilder<TransportFolder> {
        protected List<TransportItem> items = new ArrayList<TransportItem>();
        protected ILocator path;
        protected ILocator handle;

        @Override
        public TransportFolder build() {
            TransportFolder result = (TransportFolder)super.build();
            if (this.path != null) {
                result.setPath(this.path);
            }
            if (this.handle != null) {
                result.setHandle(this.handle);
            }
            for (TransportItem item : this.items) {
                result.addItem(item);
            }
            return result;
        }

        @Override
        protected TransportFolder createResult() {
            return new TransportFolder();
        }

        public TransportFolderBuilder handle(ILocator handle) {
            this.handle = handle;
            return this;
        }

        public TransportFolderBuilder item(TransportItem item) {
            this.items.add(item);
            return this;
        }

        public TransportFolderBuilder name(String name) {
            return (TransportFolderBuilder)super.name(name);
        }

        public TransportFolderBuilder path(ILocator locator) {
            this.path = locator;
            return this;
        }

        public TransportFolderBuilder property(String name, Object value) {
            return (TransportFolderBuilder)super.property(name, value);
        }
    }
}

