/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.common.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportFolder;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportItemDeserializer;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jackson.ArgsToJavaConverter;
import de.intarsys.tools.jackson.JavaToArgsConverter;
import de.intarsys.tools.jaxrs.ServiceParam;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.string.StringTools;

@JsonDeserialize(using=TransportItemDeserializer.class)
@JsonPropertyOrder(value={"type", "name"})
@ServiceParam
public abstract class TransportItem {
    private String name;
    @JsonIgnore
    private final AttributeMap attributes = new AttributeMap();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonSerialize(converter=ArgsToJavaConverter.class)
    @JsonDeserialize(converter=JavaToArgsConverter.class)
    private IArgs properties = Args.create();
    @JsonIgnore
    private TransportFolder parent;

    public TransportItem() {
    }

    public TransportItem(String name) {
        this.name = name;
    }

    public void addProperties(IArgs properties) {
        ArgTools.putAllDeep((IArgs)this.properties, (IArgs)properties);
    }

    protected String basicGetName() {
        return this.name;
    }

    @JsonIgnore
    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    @JsonIgnore
    public abstract ILocator getLocator();

    public String getName() {
        if (StringTools.isEmpty((String)this.name)) {
            return "undefined";
        }
        return this.name;
    }

    public TransportFolder getParent() {
        return this.parent;
    }

    public IArgs getProperties() {
        return this.properties;
    }

    public Object getProperty(String name) {
        return ArgTools.getObject((IArgs)this.properties, (String)name, null);
    }

    @JsonProperty(value="type")
    public String getType() {
        return "";
    }

    @JsonIgnore
    public boolean isDocument() {
        return false;
    }

    @JsonIgnore
    public boolean isFolder() {
        return false;
    }

    @JsonIgnore
    public boolean isLink() {
        return false;
    }

    @JsonIgnore
    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    @JsonIgnore
    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public abstract void setContent(ILocator var1);

    public abstract void setHandle(ILocator var1);

    public void setName(String name) {
        this.name = name;
    }

    public void setParent(TransportFolder parent) {
        this.parent = parent;
    }

    public abstract void setPath(ILocator var1);

    public void setProperties(IArgs properties) {
        this.properties = properties;
    }

    public void setProperty(String name, Object value) {
        ArgTools.putPath((IArgs)this.properties, (String)name, (Object)value);
    }

    public static abstract class TransportItemBuilder<R extends TransportItem> {
        private IArgs properties = Args.create();
        private String name;

        public R build() {
            R result = this.createResult();
            ((TransportItem)result).setProperties(this.properties);
            ((TransportItem)result).setName(this.name);
            return result;
        }

        protected abstract R createResult();

        public TransportItemBuilder<R> name(String name) {
            this.name = name;
            return this;
        }

        public TransportItemBuilder<R> property(String name, Object value) {
            ArgTools.putPath((IArgs)this.properties, (String)name, (Object)value);
            return this;
        }
    }
}

