/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.common.jackson;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.ITransportItemLocatorFactory;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.TransportDocumentLocatorDeserializer;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportDocumentLocatorContentDeserializer
extends TransportDocumentLocatorDeserializer {
    private static final Logger Log = LoggerFactory.getLogger(TransportDocumentLocatorContentDeserializer.class);

    protected TransportDocumentLocatorContentDeserializer() {
        super(ILocator.class);
    }

    public ILocator deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        ITransportItemLocatorFactory factory = TransportDocumentLocatorContentDeserializer.getLocatorFactory(ctxt);
        if (factory == null) {
            factory = TransportDocumentLocatorContentDeserializer.getLocatorFactory();
        }
        ILocator locator = factory.createLocator(parser, ctxt);
        Base64Variant variant = Base64Variants.getDefaultVariant();
        try (OutputStream os = locator.getOutputStream();){
            int read = parser.readBinaryValue(variant, os);
            Log.debug("{} deserialized {} with {} bytes", new Object[]{((Object)((Object)this)).getClass(), locator.getName(), read});
        }
        return locator;
    }
}

