/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.common.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportFolder;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportItem;
import de.intarsys.cloudsuite.gears.core.service.common.jackson.ITransportItemDeserializerCallback;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class TransportItemDeserializer
extends StdDeserializer<TransportItem> {
    private static final String FIELD_NAME = "name";
    private static final String FIELD_TYPE = "type";
    private static final Logger Log = LoggerFactory.getLogger(TransportItemDeserializer.class);
    private final ITransportItemDeserializerCallback callback;

    public TransportItemDeserializer() {
        super(TransportItem.class);
        this.callback = null;
    }

    public TransportItemDeserializer(ITransportItemDeserializerCallback callback) {
        super(TransportItem.class);
        this.callback = callback;
    }

    protected void assignParent(JsonParser parser, TransportItem item) {
        Object parentCandidate;
        JsonStreamContext context = parser.getParsingContext();
        if (context != null) {
            context = context.getParent();
        }
        if (context != null) {
            context = context.getParent();
        }
        if (context != null && (parentCandidate = context.getCurrentValue()) instanceof TransportFolder) {
            item.setParent((TransportFolder)parentCandidate);
        }
    }

    protected JsonDeserializer createDeserializer(DeserializationContext ctxt, Class clazz) throws IOException {
        JavaType type = ctxt.getTypeFactory().constructType((Type)clazz);
        BeanDescription beanDesc = ctxt.getConfig().introspect(type);
        JsonDeserializer deser = ctxt.getFactory().createBeanDeserializer(ctxt, type, beanDesc);
        if (deser instanceof ResolvableDeserializer) {
            ((ResolvableDeserializer)deser).resolve(ctxt);
        }
        return deser;
    }

    public TransportItem deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonToken token = parser.getCurrentToken();
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        if (token == JsonToken.START_OBJECT) {
            if (Log.isEnabledForLevel(Level.TRACE)) {
                Log.trace("memory: total {}, free {}", (Object)Runtime.getRuntime().totalMemory(), (Object)Runtime.getRuntime().freeMemory());
            }
            token = parser.nextToken();
            String tokenText = parser.getText();
            if (FIELD_TYPE.equals(tokenText)) {
                parser.nextToken();
                String typeId = parser.getText();
                if ("d".equals(typeId)) {
                    parser.nextToken();
                    return this.deserializeDocument(parser, ctxt);
                }
                if ("f".equals(typeId)) {
                    parser.nextToken();
                    return this.deserializeFolder(parser, ctxt);
                }
                throw new JsonMappingException((Closeable)parser, "'type' " + typeId + " not supported");
            }
            if (FIELD_NAME.equals(tokenText)) {
                return this.deserializeDocument(parser, ctxt);
            }
            throw new JsonMappingException((Closeable)parser, "'type' required as first element, found " + tokenText);
        }
        throw new JsonMappingException((Closeable)parser, "unsupported token " + token);
    }

    protected TransportItem deserializeDocument(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonDeserializer deser = this.createDeserializer(ctxt, TransportDocument.class);
        String tokenText = parser.getText();
        if (FIELD_NAME.equals(tokenText)) {
            parser.nextToken();
            tokenText = parser.getText();
            parser.nextToken();
            TransportDocument result = new TransportDocument(tokenText);
            parser.setCurrentValue((Object)result);
            this.assignParent(parser, result);
            if (this.callback != null) {
                this.callback.transportDocumentCreated(result, parser, ctxt);
            }
            Log.debug("creating document {}", (Object)result);
            deser.deserialize(parser, ctxt, (Object)result);
            if (this.callback != null) {
                this.callback.transportDocumentDeserialized(result, parser, ctxt);
            }
            return result;
        }
        throw new JsonMappingException((Closeable)parser, "'name' required as second element");
    }

    protected TransportFolder deserializeFolder(JsonParser parser, DeserializationContext ctxt) throws IOException {
        JsonDeserializer deser = this.createDeserializer(ctxt, TransportFolder.class);
        String tokenText = parser.getText();
        if (FIELD_NAME.equals(tokenText)) {
            parser.nextToken();
            tokenText = parser.getText();
            parser.nextToken();
            TransportFolder result = new TransportFolder(tokenText);
            parser.setCurrentValue((Object)result);
            this.assignParent(parser, result);
            Log.debug("creating folder {}", (Object)result);
            if (this.callback != null) {
                this.callback.transportFolderCreated(result, parser, ctxt);
            }
            deser.deserialize(parser, ctxt, (Object)result);
            if (this.callback != null) {
                this.callback.transportFolderDeserialized(result, parser, ctxt);
            }
            return result;
        }
        throw new JsonMappingException((Closeable)parser, "'name' required as second element");
    }
}

