/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import com.steadystate.css.parser.selectors.AbstractMatcher;
import com.steadystate.css.parser.selectors.IMatcher;
import com.steadystate.css.parser.selectors.Match;
import com.steadystate.css.parser.selectors.MatchImpl;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.Map;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSStyleRuleImpl
extends AbstractMatcher
implements CSSStyleRule,
Serializable {
    private CSSStyleSheetImpl _parentStyleSheet = null;
    private CSSRule _parentRule = null;
    private SelectorList _selectors = null;
    private CSSStyleDeclaration _style = null;

    public CSSStyleRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule, SelectorList selectors) {
        this._parentStyleSheet = parentStyleSheet;
        this._parentRule = parentRule;
        this._selectors = selectors;
    }

    @Override
    public short getType() {
        return 1;
    }

    @Override
    public String getCssText() {
        return this.getSelectorText() + " " + this.getStyle().toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 1) {
                throw new DOMExceptionImpl(13, 4);
            }
            this._selectors = ((CSSStyleRuleImpl)r)._selectors;
            this._style = ((CSSStyleRuleImpl)r)._style;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    @Override
    public CSSStyleSheet getParentStyleSheet() {
        return this._parentStyleSheet;
    }

    @Override
    public CSSRule getParentRule() {
        return this._parentRule;
    }

    @Override
    public String getSelectorText() {
        return this._selectors.toString();
    }

    @Override
    public void setSelectorText(String selectorText) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(selectorText));
            CSSOMParser parser = new CSSOMParser();
            this._selectors = parser.parseSelectors(is);
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    @Override
    public CSSStyleDeclaration getStyle() {
        return this._style;
    }

    public void setStyle(CSSStyleDeclarationImpl style) {
        this._style = style;
    }

    public String toString() {
        return this.getCssText();
    }

    public SelectorList getSelectors() {
        return this._selectors;
    }

    @Override
    public Match match(String element, Map attributes) {
        Match result = null;
        for (int j = 0; j < this.getSelectors().getLength(); ++j) {
            IMatcher matcher;
            Match currentMatch;
            Selector selector = this.getSelectors().item(j);
            if (!(selector instanceof IMatcher) || (currentMatch = (matcher = (IMatcher)((Object)selector)).match(element, attributes)) == null) continue;
            boolean id = result == null ? false : result.matchesId();
            boolean elem = result == null ? false : result.matchesElement();
            boolean clazz = result == null ? false : result.matchesClass();
            id = id || currentMatch.matchesId();
            elem = elem || currentMatch.matchesElement();
            clazz = clazz || currentMatch.matchesClass();
            result = new MatchImpl(id, elem, clazz);
        }
        return result;
    }
}

