/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.flow.common;

import de.intarsys.cloudsuite.flow.common.FlowConfiguration;
import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.component.IDisposable;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.expression.ResolveProperty;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.List;

public abstract class CommonFlow
implements IOptionSupport,
IDisposable {
    private static final Attribute ATTR_FLOW = new Attribute("flow");
    private static final IArgs EMPTY_VARIABLES = Args.create();
    private IConversation<?> conversation;
    private FlowConfiguration configuration;
    private IArgs args;
    private String label;
    private Object result;
    private List<IDisposable> toBeDisposed = new ArrayList<IDisposable>();
    private IArgs options = Args.create();

    public static <T extends CommonFlow> T getFlow(IConversation<?> conversation, Class<T> clazz) {
        Object flow = conversation.getAttribute((Object)ATTR_FLOW);
        if (flow == null) {
            throw new IllegalArgumentException("invalid conversation " + conversation.getHandle());
        }
        return (T)((CommonFlow)clazz.cast(flow));
    }

    public void addToBeDisposed(IDisposable disposable) {
        this.toBeDisposed.add(disposable);
    }

    protected String createDefaultLabel() {
        return "";
    }

    public void dispose() {
        for (IDisposable disposable : this.toBeDisposed) {
            disposable.dispose();
        }
    }

    public IArgs getArgs() {
        return this.args;
    }

    public FlowConfiguration getConfiguration() {
        return this.configuration;
    }

    public IConversation<?> getConversation() {
        return this.conversation;
    }

    public String getId() {
        return this.getConversation().getHandle();
    }

    public String getLabel() {
        if (StringTools.isEmpty((String)this.label)) {
            return this.createDefaultLabel();
        }
        return this.label;
    }

    public Object getOption(String name) {
        if (this.options == null) {
            return null;
        }
        return ArgTools.getObject((IArgs)this.options, (String)name, null);
    }

    public IArgs getOptions() {
        return this.options;
    }

    public Object getResult() {
        return this.result;
    }

    public List<IDisposable> getToBeDisposed() {
        return this.toBeDisposed;
    }

    @ResolveProperty(property="variables")
    public IArgs getVariables() {
        return this.configuration.getVariables();
    }

    public void setArgs(IArgs args) {
        this.args = args;
    }

    public void setConfiguration(FlowConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setConversation(IConversation<?> conversation) {
        this.conversation = conversation;
        conversation.setAttribute((Object)ATTR_FLOW, (Object)this);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setOption(String name, Object value) {
        ArgTools.putPath((IArgs)this.options, (String)name, (Object)value);
    }

    public void setOptions(IArgs options) {
        if (options == null) {
            options = Args.create();
        }
        this.options = options;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void setToBeDisposed(List<IDisposable> toBeDisposed) {
        this.toBeDisposed = toBeDisposed;
    }
}

