/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.flow.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.intarsys.aaa.authorization.api.AuthorizationStrategy;
import de.intarsys.aaa.resource.IOperation;
import de.intarsys.aaa.resource.IResource;
import de.intarsys.aaa.resource.SimpleObjectResource;
import de.intarsys.aaa.resource.SimpleOperation;
import de.intarsys.cloudsuite.flow.common.IConfigurationProvider;
import de.intarsys.cloudsuite.gears.core.service.common.api.DtoArgumentDefinition;
import de.intarsys.cloudsuite.gears.plugin.PluginSpec;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jackson.ArgsToJavaConverter;
import de.intarsys.tools.jackson.JavaToArgsConverter;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class FlowConfiguration {
    private String id;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String label;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private boolean defaultValue;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<DtoArgumentDefinition> arguments = new ArrayList<DtoArgumentDefinition>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonSerialize(converter=ArgsToJavaConverter.class)
    @JsonDeserialize(converter=JavaToArgsConverter.class)
    private IArgs variables = Args.create();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<PluginSpec> plugins = new ArrayList<PluginSpec>();

    public static void checkAccess(Class<?> type, String id) {
        String typeName = ClassTools.getUnqualifiedName(type);
        SimpleObjectResource resource = SimpleObjectResource.createFromString((String)typeName, (String)id);
        SimpleOperation operation = SimpleOperation.parse((String)"execute");
        AuthorizationStrategy.get().checkAccess((IResource)resource, (IOperation)operation);
    }

    public static <C extends FlowConfiguration> C createConfiguration(Object configuration, Class<C> type, IConfigurationProvider provider, ObjectMapper objectMapper) {
        C basic = FlowConfiguration.createConfigurationBasic(configuration, type, provider, objectMapper);
        if (basic != null) {
            return (C)((FlowConfiguration)basic).copy();
        }
        return null;
    }

    protected static <C extends FlowConfiguration> C createConfigurationBasic(Object configuration, Class<C> type, IConfigurationProvider provider, ObjectMapper objectMapper) {
        if (configuration == null || configuration instanceof String) {
            return FlowConfiguration.createConfigurationString((String)configuration, type, provider, objectMapper);
        }
        if (type.isInstance(configuration)) {
            return (C)((FlowConfiguration)configuration);
        }
        if (configuration instanceof IArgs) {
            configuration = ArgTools.toJavaDeep((IArgs)((IArgs)configuration));
        }
        if (configuration instanceof List) {
            return FlowConfiguration.createConfigurationList((List)configuration, type, provider, objectMapper);
        }
        if (configuration instanceof Map) {
            return FlowConfiguration.createConfigurationMap((Map)configuration, type, provider, objectMapper);
        }
        throw new IllegalArgumentException("unspported configuration (" + configuration + ")");
    }

    protected static <C extends FlowConfiguration> C createConfigurationList(List configuration, Class<C> type, IConfigurationProvider provider, ObjectMapper objectMapper) {
        FlowConfiguration result = null;
        for (Object config : configuration) {
            C basic = FlowConfiguration.createConfigurationBasic(config, type, provider, objectMapper);
            if (basic == null) continue;
            if (result == null) {
                result = ((FlowConfiguration)basic).copy();
                continue;
            }
            result.merge((FlowConfiguration)basic);
        }
        return (C)result;
    }

    protected static <C extends FlowConfiguration> C createConfigurationMap(Map configuration, Class<C> type, IConfigurationProvider provider, ObjectMapper objectMapper) {
        FlowConfiguration.checkAccess(type, "_transient_");
        return (C)((FlowConfiguration)objectMapper.convertValue((Object)configuration, type));
    }

    protected static <C extends FlowConfiguration> C createConfigurationString(String configId, Class<C> type, IConfigurationProvider provider, ObjectMapper objectMapper) {
        C config = provider.getConfiguration(type, configId);
        if (config != null) {
            FlowConfiguration.checkAccess(type, ((FlowConfiguration)config).getId());
        }
        return config;
    }

    public FlowConfiguration copy() {
        FlowConfiguration copy = this.createBasic();
        copy.copyBasic(this);
        return copy;
    }

    protected void copyBasic(FlowConfiguration other) {
        this.setArguments(new ArrayList<DtoArgumentDefinition>(other.getArguments()));
        this.setDefaultValue(other.isDefaultValue());
        this.setDescription(other.getDescription());
        this.setId(other.getId());
        this.setLabel(other.getLabel());
        this.setVariables(other.getVariables().copy());
        this.setPlugins(new ArrayList<PluginSpec>(other.getPlugins()));
    }

    protected abstract FlowConfiguration createBasic();

    public void expand(IStringEvaluator evaluator) {
    }

    public List<DtoArgumentDefinition> getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return this.description;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public List<PluginSpec> getPlugins() {
        return this.plugins;
    }

    public IArgs getVariables() {
        return this.variables;
    }

    public boolean isDefaultValue() {
        return this.defaultValue;
    }

    public void merge(FlowConfiguration other) {
        if (!StringTools.isEmpty((String)other.getId())) {
            this.setId(other.getId());
        }
        if (!StringTools.isEmpty((String)other.getLabel())) {
            this.setLabel(other.getLabel());
        }
        if (!StringTools.isEmpty((String)other.getDescription())) {
            this.setDescription(other.getDescription());
        }
        this.getArguments().addAll(other.getArguments());
        ArgTools.putAllDeep((IArgs)this.getVariables(), (IArgs)other.getVariables());
        this.getPlugins().addAll(other.getPlugins());
    }

    public void setArguments(List<DtoArgumentDefinition> arguments) {
        this.arguments = arguments;
    }

    public void setDefaultValue(boolean defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setDefinitions(Map<String, Object> definitions) {
        this.arguments.clear();
        for (Map.Entry<String, Object> definition : definitions.entrySet()) {
            DtoArgumentDefinition argumentDefinition = new DtoArgumentDefinition(definition.getKey(), definition.getValue());
            this.arguments.add(argumentDefinition);
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setPlugins(List<PluginSpec> plugins) {
        this.plugins = plugins;
    }

    public void setVariables(IArgs variables) {
        this.variables = variables;
    }
}

