/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.flow.common;

import de.intarsys.cloudsuite.flow.common.FlowConfiguration;
import de.intarsys.cloudsuite.flow.common.StaticConfigurationProvider;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticConfigurationHolder {
    private static final Logger Log = LoggerFactory.getLogger(StaticConfigurationProvider.class);
    private final StaticConfigurationProvider provider;
    private final ILocator locator;
    private volatile FlowConfiguration configuration;

    public StaticConfigurationHolder(StaticConfigurationProvider provider, ILocator locator, FlowConfiguration configuration) {
        this.provider = provider;
        this.locator = locator;
        this.configuration = configuration;
    }

    public FlowConfiguration getConfiguration() {
        return this.configuration;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public StaticConfigurationProvider getProvider() {
        return this.provider;
    }

    public boolean isOutOfSynch() {
        return this.locator.isOutOfSynch();
    }

    protected void reload() {
        Object newConfiguration = null;
        this.configuration = newConfiguration;
    }

    public void synch() {
        if (!this.isOutOfSynch()) {
            return;
        }
        try {
            Object newConfiguration = this.getProvider().load(this.configuration.getClass(), this.locator);
            this.configuration = newConfiguration;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("configuration '" + this.configuration.getId() + "' cannot be synched(" + ExceptionTools.getMessage((Throwable)e) + ")", e);
        }
    }
}

