/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.flow.common;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDelegatingDeserializer;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdDelegatingSerializer;
import com.fasterxml.jackson.databind.util.Converter;
import de.intarsys.cloudsuite.flow.common.FlowConfiguration;
import de.intarsys.cloudsuite.flow.common.IConfigurationProvider;
import de.intarsys.cloudsuite.flow.common.StaticConfigurationHolder;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.file.PathTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.jackson.ArgsToJavaConverter;
import de.intarsys.tools.jackson.JavaToArgsConverter;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.string.StringTools;
import de.intarsys.widget.json.WidgetModule;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class StaticConfigurationProvider
implements IConfigurationProvider {
    private ObjectMapper mapper;
    @Value(value="${cloudsuite.config.shared}/configurations")
    private File externalPath;
    @Autowired(required=false)
    private List<FlowConfiguration> springConfigurations;
    private List<StaticConfigurationHolder> externalConfigurations = new CopyOnWriteArrayList<StaticConfigurationHolder>();

    protected <T extends FlowConfiguration> boolean accept(FlowConfiguration configuration, Class<T> clazz, String id) {
        return clazz.isInstance(configuration) && (StringTools.isEmpty((String)id) ? configuration.isDefaultValue() : id.equals(configuration.getId()));
    }

    @Override
    public <T extends FlowConfiguration> T getConfiguration(Class<T> clazz, String id) {
        if (this.springConfigurations != null) {
            for (FlowConfiguration config : this.springConfigurations) {
                if (!this.accept(config, clazz, id)) continue;
                return (T)config;
            }
        }
        for (StaticConfigurationHolder holder : this.externalConfigurations) {
            if (!this.accept(holder.getConfiguration(), clazz, id)) continue;
            holder.synch();
            return (T)holder.getConfiguration();
        }
        if (StringTools.isEmpty((String)id)) {
            return null;
        }
        try {
            StaticConfigurationHolder newHolder = this.load(clazz, id);
            if (newHolder != null) {
                this.externalConfigurations.add(newHolder);
                return (T)newHolder.getConfiguration();
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("configuration '" + id + "' cannot be loaded (" + ExceptionTools.getMessage((Throwable)e) + ")", e);
        }
        throw new IllegalArgumentException("configuration '" + id + "' not found");
    }

    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @PostConstruct
    public void init() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(IArgs.class, (JsonSerializer)new StdDelegatingSerializer((Converter)new ArgsToJavaConverter()));
        module.addDeserializer(IArgs.class, (JsonDeserializer)new StdDelegatingDeserializer((Converter)new JavaToArgsConverter()));
        this.mapper = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_JAVA_COMMENTS}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_SINGLE_QUOTES}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_TRAILING_COMMA}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_UNQUOTED_FIELD_NAMES}).addModule((Module)new WidgetModule())).addModule((Module)module)).build();
    }

    protected <T extends FlowConfiguration> T load(Class<T> clazz, ILocator locator) throws IOException {
        InputStream is = locator.getInputStream();
        FlowConfiguration result = (FlowConfiguration)this.getMapper().readValue(is, clazz);
        if (!StringTools.isEmpty((String)result.getId())) {
            throw new IllegalArgumentException("'id' must be empty");
        }
        result.setId(PathTools.getBaseName((String)locator.getName()));
        return (T)result;
    }

    protected <T extends FlowConfiguration> StaticConfigurationHolder load(Class<T> clazz, String id) throws IOException {
        File folder = new File(this.externalPath, clazz.getName());
        File file = new File(folder, id + ".json");
        FileLocator locator = new FileLocator(file);
        if (!locator.exists()) {
            return null;
        }
        locator.setSynchSynchronous(true);
        try {
            T config = this.load(clazz, (ILocator)locator);
            return new StaticConfigurationHolder(this, (ILocator)locator, (FlowConfiguration)config);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }
}

