/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.action;

import de.intarsys.cloudsuite.gears.action.PACKAGE;
import de.intarsys.cloudsuite.gears.action.ServerAction;
import de.intarsys.cloudsuite.gears.flow.common.CoreFlow;
import de.intarsys.cloudsuite.gears.flow.common.IResourceHolder;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.presentation.IPresentationSupport;
import de.intarsys.tools.presentation.PresentationAdapter;
import java.util.ArrayList;
import java.util.List;

public class ActionInvocation
implements IResourceHolder,
IPresentationSupport {
    public static final String ARG_EMBEDDED = "embedded";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private final CoreFlow flow;
    private final IArgs args;
    private final ServerAction action;
    private final List<Object> resources = new ArrayList<Object>();
    private IConversation<?> conversation;

    public ActionInvocation(ServerAction action, CoreFlow flow, IArgs args) {
        this.action = action;
        this.flow = flow;
        this.args = args.copy();
    }

    public ServerAction getAction() {
        return this.action;
    }

    public IArgs getArgs() {
        return this.args;
    }

    public IConversation<?> getConversation() {
        return this.conversation;
    }

    public String getDescription() {
        return this.getTip();
    }

    public CoreFlow getFlow() {
        return this.flow;
    }

    public String getIconName() {
        return null;
    }

    public String getLabel() {
        StringBuilder sb = new StringBuilder();
        for (Object resource : this.resources) {
            sb.append("'");
            sb.append(PresentationAdapter.create((Object)resource, (String)"Objekt").getLabel());
            sb.append("', ");
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 2);
        }
        return Msg.getString("ActionInvocation.label", new Object[]{this.getAction().getLabel(this), sb.toString()});
    }

    public List<Object> getResources() {
        return this.resources;
    }

    public String getTip() {
        return this.getLabel();
    }

    public boolean isEmbedded() {
        return ArgTools.getBoolStrict((IArgs)this.getArgs(), (String)ARG_EMBEDDED, (boolean)false);
    }

    protected void setConversation(IConversation<?> conversation) {
        this.conversation = conversation;
    }
}

