/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.action;

import de.intarsys.cloudsuite.gears.action.ActionInvocation;
import de.intarsys.cloudsuite.gears.action.CommonAction;
import de.intarsys.cloudsuite.gears.action.IServerAction;
import de.intarsys.cloudsuite.gears.flow.common.CoreFlow;
import de.intarsys.cloudsuite.gears.service.decorate.ConversationalIncovationHandler;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.MessageTools;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerAction
extends CommonAction
implements IServerAction {
    private static final Logger Log = LoggerFactory.getLogger(ServerAction.class);
    private static final InvocationHandler invocationHandler = new ConversationalIncovationHandler();

    protected void basicAcquire(ActionInvocation invocation) {
        invocation.getFlow().invocationBegin(invocation);
    }

    protected abstract IConversation<?> basicInvoke(ActionInvocation var1) throws Exception;

    protected void basicRelease(ActionInvocation invocation) {
        invocation.getFlow().invocationDispose(invocation);
    }

    protected Object callResource(Class<?> targetClass, String targetName, Object targetArg) throws NoSuchMethodException, Throwable {
        Object resource = this.getContext().getResource(targetClass);
        Method method = targetClass.getMethod(targetName, targetArg.getClass());
        return invocationHandler.invoke(resource, method, new Object[]{targetArg});
    }

    protected IConversation<?> createConversation(ActionInvocation invocation) {
        IConversation conversation;
        try {
            conversation = this.basicInvoke(invocation);
        }
        catch (Exception e) {
            conversation = Conversation.failed((Throwable)e);
        }
        invocation.setConversation(conversation);
        return conversation;
    }

    public String getLabel(ActionInvocation actionInvocation) {
        return MessageTools.getMessage((Object)this, (String)"label", (Object[])new Object[0]).getString();
    }

    @Override
    public IConversation<?> invoke(CoreFlow flow, IArgs args) {
        ActionInvocation invocation = new ActionInvocation(this, flow, args);
        this.basicAcquire(invocation);
        IConversation<?> conversation = this.createConversation(invocation);
        conversation.whenComplete((result, ex) -> this.basicRelease(invocation));
        return conversation;
    }
}

