/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.assertion;

import de.intarsys.cloudsuite.gears.assertion.IAssert;
import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public final class AssertionTools {
    public static void runAssertions(IArgs assertions, String phase, IArgs argsCheck) {
        IArgs argsPhase = ArgTools.getArgs((IArgs)assertions, (String)phase, null);
        if (argsPhase == null) {
            return;
        }
        for (IArgs.IBinding binding : argsPhase) {
            IAssert assertion;
            InstanceSpec assertionSpec = InstanceSpec.createFromArgs(IAssert.class, (Object)binding.getValue());
            try {
                assertion = (IAssert)assertionSpec.createInstance();
            }
            catch (ObjectCreationException e) {
                throw new AssertionError((Object)"can not create assertion");
            }
            assertion.check(argsCheck);
        }
    }

    public static void runAssertions(IOptionSupport optionSupport, String phase, IArgs argsCheck) {
        IArgs assertions = ArgTools.toArgs((Object)optionSupport.getOption("assert"));
        if (assertions == null) {
            return;
        }
        AssertionTools.runAssertions(assertions, phase, argsCheck);
    }

    public static void runAssertionsAfter(IOptionSupport optionSupport, IArgs argsCheck) {
        AssertionTools.runAssertions(optionSupport, "after", argsCheck);
    }

    public static void runAssertionsBefore(IOptionSupport optionSupport, IArgs argsCheck) {
        AssertionTools.runAssertions(optionSupport, "before", argsCheck);
    }

    private AssertionTools() {
    }
}

