/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.common.impl;

import de.intarsys.cloudsuite.gears.assertion.IAssert;
import de.intarsys.cloudsuite.gears.core.service.common.impl.RepositoryDocumentState;
import de.intarsys.cloudsuite.gears.core.service.common.impl.SvcRepositoryBased;
import de.intarsys.cloudsuite.gears.flow.common.RepositoryBasedFlow;
import de.intarsys.cloudsuite.gears.repository.encryption.EncryptionInfo;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryDocument;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryItemMetadata;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IArgsAccess;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import java.io.IOException;

public class AssertEncrypted
implements IAssert,
IArgsAccess {
    private IArgs args;

    @Override
    public void check(IArgs argsCheck) {
        SvcRepositoryBased service = (SvcRepositoryBased)ArgTools.get((IArgs)argsCheck, (String)"service", SvcRepositoryBased.class, null);
        RepositoryBasedFlow flow = (RepositoryBasedFlow)ArgTools.get((IArgs)argsCheck, (String)"flow", RepositoryBasedFlow.class, null);
        String content = ArgTools.getString((IArgs)this.getArgs(), (String)"content", null);
        for (RepositoryDocumentState state : flow.getRepoDocStates()) {
            RepositoryDocument doc = state.getRepoDoc();
            RepositoryItemMetadata meta = doc.getMetadata();
            EncryptionInfo encryption = meta.getEncryptionInfo();
            if (encryption == null) {
                throw new IllegalStateException("should be encrypted");
            }
            if (content == null) continue;
            try {
                String decryptedContent = LocatorTools.getString((ILocator)doc.getLocator());
                if (content.equals(decryptedContent)) continue;
                throw new IllegalStateException("decryption failure");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public IArgs getArgs() {
        return this.args;
    }

    public void setArgs(IArgs args) {
        this.args = args;
    }
}

