/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.common.impl;

import de.intarsys.cloudsuite.flow.common.FlowConfiguration;
import de.intarsys.cloudsuite.tools.common.Settings;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.widget.common.ActionExpander;
import de.intarsys.widget.common.WidgetExpander;
import de.intarsys.widget.model.ActionSpec;
import de.intarsys.widget.model.WidgetDefinition;
import java.util.ArrayList;
import java.util.List;

public abstract class FlowInteractiveConfiguration
extends FlowConfiguration {
    private List<WidgetDefinition> widgets = new ArrayList<WidgetDefinition>();
    private Settings settings;
    private List<ActionSpec> actions = new ArrayList<ActionSpec>();

    @Override
    protected void copyBasic(FlowConfiguration other) {
        super.copyBasic(other);
        this.setActions(new ArrayList<ActionSpec>(((FlowInteractiveConfiguration)other).getActions()));
        this.setSettings(((FlowInteractiveConfiguration)other).getSettings());
        this.setWidgets(new ArrayList<WidgetDefinition>(((FlowInteractiveConfiguration)other).getWidgets()));
    }

    @Override
    public void expand(IStringEvaluator evaluator) {
        super.expand(evaluator);
        List tempWidgets = ListTools.copyDeep(this.getWidgets());
        WidgetExpander.process((IStringEvaluator)evaluator, (List)tempWidgets);
        this.widgets = tempWidgets;
        List tempActions = ListTools.copyDeep(this.getActions());
        ActionExpander.process((IStringEvaluator)evaluator, (List)tempActions);
        this.actions = tempActions;
    }

    public List<ActionSpec> getActions() {
        return this.actions;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public List<WidgetDefinition> getWidgets() {
        return this.widgets;
    }

    @Override
    public void merge(FlowConfiguration other) {
        super.merge(other);
        this.getActions().addAll(((FlowInteractiveConfiguration)other).getActions());
        this.getWidgets().addAll(((FlowInteractiveConfiguration)other).getWidgets());
    }

    public void setActions(List<ActionSpec> actions) {
        this.actions = actions;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public void setWidgetDefinitions(List<WidgetDefinition> widgetDefinitions) {
        this.widgets = widgetDefinitions;
    }

    public void setWidgets(List<WidgetDefinition> widgetDefinitions) {
        this.widgets = widgetDefinitions;
    }
}

