/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.common.impl;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryDocument;
import de.intarsys.cloudsuite.gears.service.jackson.JacksonTools;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.presentation.IPresentationSupport;

public class RepositoryDocumentState
implements IAttributeSupport,
IPresentationSupport {
    @JsonIgnore
    private final AttributeMap attributes = new AttributeMap();
    private boolean imported;
    private RepositoryDocument repoDoc;
    private String repoPath;

    public static RepositoryDocumentState create(Object object) {
        if (object instanceof TransportDocument) {
            TransportDocument transportDoc = (TransportDocument)object;
            RepositoryDocument repoDoc = (RepositoryDocument)JacksonTools.getRepositoryItem(object);
            if (repoDoc == null) {
                throw new IllegalStateException("no repository entry found for TransportDocument '" + transportDoc.getName() + "', check deserialization");
            }
            RepositoryDocumentState repoLink = new RepositoryDocumentState();
            repoLink.setImported(!transportDoc.isLink());
            repoLink.setRepoDoc(repoDoc);
            repoLink.setRepoPath(repoDoc.getPath());
            repoDoc.getProperties().setProperties(transportDoc.getProperties());
            return repoLink;
        }
        throw new IllegalArgumentException("TransportDocument expected, found " + object + " instead");
    }

    public Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    public String getDescription() {
        return this.getTip();
    }

    public String getIconName() {
        return null;
    }

    public String getLabel() {
        return this.getRepoDoc().getLocator().getName();
    }

    public RepositoryDocument getRepoDoc() {
        return this.repoDoc;
    }

    public String getRepoPath() {
        return this.repoPath;
    }

    public String getTip() {
        return this.getLabel();
    }

    public boolean isImported() {
        return this.imported;
    }

    public Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public Object setAttribute(Object key, Object value) {
        return this.attributes.setAttribute(key, value);
    }

    public void setImported(boolean imported) {
        this.imported = imported;
    }

    public void setRepoDoc(RepositoryDocument repoItem) {
        this.repoDoc = repoItem;
    }

    public void setRepoPath(String repoPath) {
        this.repoPath = repoPath;
    }
}

