/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cloudsuite.gears.core.service.common.impl;

import de.intarsys.aaa.authorization.api.AuthorizationStrategy;
import de.intarsys.aaa.resource.IOperation;
import de.intarsys.aaa.resource.IResource;
import de.intarsys.aaa.resource.SimpleObjectResource;
import de.intarsys.aaa.resource.SimpleOperation;
import de.intarsys.cloudsuite.flow.common.CommonFlow;
import de.intarsys.cloudsuite.gears.action.IServerAction;
import de.intarsys.cloudsuite.gears.assertion.AssertionTools;
import de.intarsys.cloudsuite.gears.core.service.common.api.FlowOptions;
import de.intarsys.cloudsuite.gears.core.service.common.api.IDocumentBasedRequest;
import de.intarsys.cloudsuite.gears.core.service.common.api.IDocumentListBasedRequest;
import de.intarsys.cloudsuite.gears.core.service.common.api.IOptionSupport;
import de.intarsys.cloudsuite.gears.core.service.common.api.ResultCommon;
import de.intarsys.cloudsuite.gears.core.service.common.api.TransportDocument;
import de.intarsys.cloudsuite.gears.core.service.common.impl.RepositoryDocumentState;
import de.intarsys.cloudsuite.gears.flow.common.RepositoryBasedFlow;
import de.intarsys.cloudsuite.gears.repository.impl.RepositoryTools;
import de.intarsys.cloudsuite.gears.repository.impl.RestrictedIdentificationProvider;
import de.intarsys.conversation.service.client.api.ConversationalResponse;
import de.intarsys.conversation.service.client.api.DtoConversationSnapshot;
import de.intarsys.conversation.service.client.api.DtoReplyStage;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.IConversationRegistry;
import de.intarsys.tools.conversation.IReplyStage;
import de.intarsys.tools.conversation.service.impl.ConversationServiceTools;
import de.intarsys.tools.crypto.api.ICipherParameter;
import de.intarsys.tools.crypto.standard.SecretKeyParameter;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.widget.model.WidgetDefinition;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.io.Closeable;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.CloseableService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SvcCommon<R extends ResultCommon> {
    public static final String OPTION_DEBUG_URL_CLIENT = "debug.urlClient";
    private static final Logger Log = LoggerFactory.getLogger(SvcCommon.class);
    protected static final ExecutorService executor = Executors.newWorkStealingPool();
    @Autowired
    private IConversationRegistry conversationRegistry;
    @Context
    private UriInfo uriInfo;
    @Context
    private CloseableService closableService;
    @Context
    private InjectionManager injectionManager;

    public static void authorizeArgs(String path, IArgs args) {
        if (args == null || args.size() == 0) {
            return;
        }
        SimpleObjectResource resource = SimpleObjectResource.createFromString((String)"Service", (String)path);
        SimpleOperation operation = SimpleOperation.parse((String)"args");
        AuthorizationStrategy.get().checkAccess((IResource)resource, (IOperation)operation);
    }

    protected SvcCommon() {
    }

    protected void createEncryption(RepositoryBasedFlow flow) {
        RestrictedIdentificationProvider.swap(null);
        String ri = FlowOptions.getRestrictedIdentification((IOptionSupport)flow);
        if (ri != null) {
            SecretKeyParameter newKey;
            try {
                newKey = new SecretKeyParameter(null, Base64.decode((String)ri));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("'restrictedIdentification' invalid", e);
            }
            for (RepositoryDocumentState repoItemState : flow.getRepoDocStates()) {
                try {
                    RepositoryTools.encrypt(repoItemState.getRepoDoc(), null, (ICipherParameter)newKey);
                }
                catch (IOException | GeneralSecurityException e) {
                    throw new InternalServerErrorException("failed to encrypt repository data", (Throwable)e);
                }
            }
        }
        RestrictedIdentificationProvider.swap(ri);
    }

    protected void createRepoDocState(List<RepositoryDocumentState> states, Set<String> names, TransportDocument document) {
        String tmpName = document.getName();
        if (names.contains(tmpName)) {
            throw new IllegalArgumentException("duplicate document name '" + tmpName + "'");
        }
        names.add(tmpName);
        states.add(RepositoryDocumentState.create(document));
    }

    protected List<RepositoryDocumentState> createRepoDocStates(Object request) {
        TransportDocument document;
        HashSet<String> names = new HashSet<String>();
        ArrayList<RepositoryDocumentState> states = new ArrayList<RepositoryDocumentState>();
        if (request instanceof IDocumentBasedRequest && (document = ((IDocumentBasedRequest)request).getDocument()) != null) {
            this.createRepoDocState(states, names, document);
        }
        if (request instanceof IDocumentListBasedRequest && ((IDocumentListBasedRequest)request).getDocuments() != null) {
            for (TransportDocument document2 : ((IDocumentListBasedRequest)request).getDocuments()) {
                this.createRepoDocState(states, names, document2);
            }
        }
        return states;
    }

    protected IServerAction createServerAction(CommonFlow flow, Object definition) {
        InstanceSpec spec = null;
        if (definition instanceof Map) {
            spec = InstanceSpec.createFromArgs(IServerAction.class, (Object)ArgTools.toArgs((Object)definition));
        }
        if (definition instanceof String) {
            spec = InstanceSpec.createFromFactory(IServerAction.class, (Object)((String)definition), null);
        }
        if (spec == null) {
            throw new IllegalArgumentException("unsupported action: " + definition);
        }
        try {
            IServerAction action = (IServerAction)spec.createInstance();
            this.getInjectionManager().inject((Object)action);
            return action;
        }
        catch (Exception e) {
            throw new InternalServerErrorException("failed to create action: " + definition, (Throwable)e);
        }
    }

    protected void finishRequest(ConversationalResponse response, final IConversation<?> conversation) {
        final IReplyStage replyStage = conversation.getReplyStage();
        this.getClosableService().add(new Closeable(){

            @Override
            public void close() throws IOException {
                if (replyStage.isFinal()) {
                    SvcCommon.this.conversationRegistry.unpublish(conversation);
                }
            }
        });
        DtoReplyStage publishedStage = ConversationServiceTools.createDtoReplyStage(conversation, (IReplyStage)replyStage);
        DtoConversationSnapshot publishedSnapshot = ConversationServiceTools.createDtoConversationSnapshot(conversation, (DtoReplyStage)publishedStage);
        response.setSnapshot(publishedSnapshot);
        Log.info("reply stage {}", (Object)replyStage.toString());
    }

    protected CloseableService getClosableService() {
        return this.closableService;
    }

    protected IConversationRegistry getConversationRegistry() {
        return this.conversationRegistry;
    }

    public InjectionManager getInjectionManager() {
        return this.injectionManager;
    }

    protected UriInfo getUriInfo() {
        return this.uriInfo;
    }

    protected IConversation<R> lookupConversation(String handle) {
        return this.getConversationRegistry().getConversation(handle);
    }

    protected <C> IConversation<C> lookupConversation(String handle, Class<C> clazz) {
        return this.getConversationRegistry().getConversation(handle);
    }

    protected void runAssertions(CommonFlow flow, String phase) {
        Args argsCheck = Args.create();
        argsCheck.put("service", (Object)this);
        argsCheck.put("flow", (Object)flow);
        AssertionTools.runAssertions(flow, phase, (IArgs)argsCheck);
    }

    public void setInjectionManager(InjectionManager injectionManager) {
        this.injectionManager = injectionManager;
    }

    protected List<WidgetDefinition> widgetDefinitionCreateDefaults(List<WidgetDefinition> widgetDefinitions) {
        if (widgetDefinitions == null) {
            widgetDefinitions = new ArrayList<WidgetDefinition>();
        }
        this.widgetDefinitionsCreateCommon(widgetDefinitions);
        this.widgetDefinitionsCreateService(widgetDefinitions);
        return widgetDefinitions;
    }

    protected WidgetDefinition widgetDefinitionGet(List<WidgetDefinition> widgetDefinitions, String id) {
        for (WidgetDefinition widget : widgetDefinitions) {
            if (widget.getRegisterName() == null || !widget.getRegisterName().equals(id)) continue;
            return widget;
        }
        for (WidgetDefinition widget : widgetDefinitions) {
            if (widget.getId() == null || !widget.getId().equals(id)) continue;
            return widget;
        }
        return null;
    }

    protected boolean widgetDefinitionHasChildren(List<WidgetDefinition> widgetDefinitions, String id) {
        WidgetDefinition root = this.widgetDefinitionGet(widgetDefinitions, id);
        if (root != null && root.getChildren() != null && !root.getChildren().isEmpty()) {
            return true;
        }
        for (WidgetDefinition widget : widgetDefinitions) {
            if (widget.getParentName() == null || !widget.getParentName().equals(id)) continue;
            return true;
        }
        return false;
    }

    protected boolean widgetDefinitionHasWidget(List<WidgetDefinition> widgetDefinitions, String id) {
        return this.widgetDefinitionGet(widgetDefinitions, id) != null;
    }

    protected void widgetDefinitionsCreateCommon(List<WidgetDefinition> widgetDefinitions) {
        WidgetDefinition child;
        if (!this.widgetDefinitionHasWidget(widgetDefinitions, "de.intarsys.widget.shortcuts")) {
            child = WidgetDefinition.builder().parentName("de.intarsys.widget.root").id("shortcuts").registerName("de.intarsys.widget.shortcuts").build();
            widgetDefinitions.add(child);
        }
        if (!this.widgetDefinitionHasWidget(widgetDefinitions, "de.intarsys.widget.toolbar")) {
            child = WidgetDefinition.builder().parentName("de.intarsys.widget.root").id("toolbar").registerName("de.intarsys.widget.toolbar").build();
            widgetDefinitions.add(child);
        }
        if (!this.widgetDefinitionHasChildren(widgetDefinitions, "de.intarsys.widget.toolbar")) {
            child = WidgetDefinition.builder().parentName("de.intarsys.widget.toolbar").id("left").registerName("de.intarsys.widget.toolbar.left").build();
            widgetDefinitions.add(child);
            child = WidgetDefinition.builder().parentName("de.intarsys.widget.toolbar").id("additions").registerName("de.intarsys.widget.toolbar.additions").build();
            widgetDefinitions.add(child);
            child = WidgetDefinition.builder().parentName("de.intarsys.widget.toolbar").id("center").registerName("de.intarsys.widget.toolbar.center").build();
            widgetDefinitions.add(child);
            child = WidgetDefinition.builder().parentName("de.intarsys.widget.toolbar").id("right").registerName("de.intarsys.widget.toolbar.right").build();
            widgetDefinitions.add(child);
        }
        if (!this.widgetDefinitionHasWidget(widgetDefinitions, "de.intarsys.widget.renderer")) {
            child = WidgetDefinition.builder().parentName("de.intarsys.widget.root").id("renderer").registerName("de.intarsys.widget.renderer").build();
            widgetDefinitions.add(child);
        }
        if (!this.widgetDefinitionHasChildren(widgetDefinitions, "de.intarsys.widget.renderer")) {
            child = WidgetDefinition.builder().parentName("de.intarsys.widget.renderer").id("overlays").registerName("de.intarsys.widget.renderer.overlays").build();
            widgetDefinitions.add(child);
        }
        if (!this.widgetDefinitionHasWidget(widgetDefinitions, "de.intarsys.widget.sidebar")) {
            child = WidgetDefinition.builder().parentName("de.intarsys.widget.root").id("sidebar").registerName("de.intarsys.widget.sidebar").build();
            widgetDefinitions.add(child);
        }
        if (!this.widgetDefinitionHasChildren(widgetDefinitions, "de.intarsys.widget.sidebar")) {
            child = WidgetDefinition.builder().parentName("de.intarsys.widget.sidebar").id("components").registerName("de.intarsys.widget.sidebar.components").build();
            widgetDefinitions.add(child);
        }
    }

    protected void widgetDefinitionsCreateService(List<WidgetDefinition> widgetDefinitions) {
    }
}

